/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import java.util.function.Supplier;
import net.jaams.jaams_weaponry.guns.util.GunUtils;
import net.jaams.jaams_weaponry.packets.ClientPacketHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class GunShootPacket {
    private final InteractionHand hand;
    private final int cooldownTicks;

    public GunShootPacket(InteractionHand hand, int cooldownTicks) {
        this.hand = hand;
        this.cooldownTicks = cooldownTicks;
    }

    public static void encode(GunShootPacket packet, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)packet.hand);
        buf.writeInt(packet.cooldownTicks);
    }

    public static GunShootPacket decode(FriendlyByteBuf buf) {
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        int cooldownTicks = buf.readInt();
        return new GunShootPacket(hand, cooldownTicks);
    }

    public static void handle(GunShootPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
                if (serverPlayer == null) {
                    return;
                }
                Level world = serverPlayer.m_9236_();
                ItemStack itemStack = serverPlayer.m_21120_(packet.hand);
                if (serverPlayer.m_36335_().m_41519_(itemStack.m_41720_())) {
                    return;
                }
                if (packet.hand == InteractionHand.OFF_HAND && ModUtils.isEntityInBattleMode((Entity)serverPlayer)) {
                    return;
                }
                GunUtils.shoot(world, serverPlayer, itemStack);
            } else {
                ClientPacketHandler.handleGunCooldownPacket(packet.hand, packet.cooldownTicks);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

