/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.packets;

import java.util.function.Supplier;
import net.jaams.jaams_weaponry.packets.ClientPacketHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class VisualRecoilPacket {
    private final float xRotRecoilIntensity;

    public VisualRecoilPacket(float xRotRecoilIntensity) {
        this.xRotRecoilIntensity = xRotRecoilIntensity;
    }

    public static void encode(VisualRecoilPacket packet, FriendlyByteBuf buf) {
        buf.writeFloat(packet.xRotRecoilIntensity);
    }

    public static VisualRecoilPacket decode(FriendlyByteBuf buf) {
        float xRotRecoilIntensity = buf.readFloat();
        return new VisualRecoilPacket(xRotRecoilIntensity);
    }

    public static void handle(VisualRecoilPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                ClientPacketHandler.handleVisualRecoilPacket(packet.xRotRecoilIntensity);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

