/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jaams.jaams_weaponry.registries.CustomParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomCritParticleData
implements ParticleOptions {
    public static final Codec<CustomCritParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(data -> Float.valueOf(data.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(data -> Float.valueOf(data.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(data -> Float.valueOf(data.b)), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size))).apply((Applicative)instance, CustomCritParticleData::new));
    public static final ParticleOptions.Deserializer<CustomCritParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CustomCritParticleData>(){

        public CustomCritParticleData fromCommand(ParticleType<CustomCritParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = reader.readFloat();
            reader.expect(' ');
            float g = reader.readFloat();
            reader.expect(' ');
            float b = reader.readFloat();
            reader.expect(' ');
            float size = reader.readFloat();
            return new CustomCritParticleData(r, g, b, size);
        }

        public CustomCritParticleData fromNetwork(ParticleType<CustomCritParticleData> type, FriendlyByteBuf buffer) {
            return new CustomCritParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        }
    };
    private final float r;
    private final float g;
    private final float b;
    private final float size;

    public CustomCritParticleData(float r, float g, float b, float size) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.size = size;
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)CustomParticles.CUSTOM_CRIT_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.size);
    }

    public String m_5942_() {
        return String.format("%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.size));
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getSize() {
        return this.size;
    }
}

