/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jaams.jaams_weaponry.registries.CustomParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomHeartParticleData
implements ParticleOptions {
    public static final Codec<CustomHeartParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(data -> Float.valueOf(data.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(data -> Float.valueOf(data.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(data -> Float.valueOf(data.b)), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size))).apply((Applicative)instance, CustomHeartParticleData::new));
    public static final ParticleOptions.Deserializer<CustomHeartParticleData> DESERIALIZER = new ParticleOptions.Deserializer<CustomHeartParticleData>(){

        public CustomHeartParticleData fromCommand(ParticleType<CustomHeartParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float g = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float b = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float size = Mth.m_14036_((float)reader.readFloat(), (float)0.1f, (float)2.0f);
            return new CustomHeartParticleData(r, g, b, size);
        }

        public CustomHeartParticleData fromNetwork(ParticleType<CustomHeartParticleData> type, FriendlyByteBuf buffer) {
            return new CustomHeartParticleData(Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)buffer.readFloat(), (float)0.1f, (float)2.0f));
        }
    };
    private final float r;
    private final float g;
    private final float b;
    private final float size;

    public CustomHeartParticleData(float r, float g, float b, float size) {
        this.r = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        this.g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        this.b = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        this.size = Mth.m_14036_((float)size, (float)0.1f, (float)2.0f);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)CustomParticles.CUSTOM_HEART_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.size);
    }

    public String m_5942_() {
        return String.format("%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.size));
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getSize() {
        return this.size;
    }
}

