/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.particles;

import net.jaams.jaams_weaponry.particles.GunSparkParticleData;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GunSparkParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private final float size;

    public static GunSparkParticleProvider provider(SpriteSet spriteSet) {
        return new GunSparkParticleProvider(spriteSet);
    }

    protected GunSparkParticle(ClientLevel world, double x, double y, double z, float size, SpriteSet sprites) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.sprites = sprites;
        this.f_107225_ = 8;
        this.f_107227_ = 1.0f;
        this.f_107228_ = 0.9f;
        this.f_107229_ = 0.1f;
        this.f_107230_ = 1.0f;
        this.size = Math.max(size, 0.0f);
        this.f_107219_ = false;
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.m_108337_(this.sprites.m_5819_(0, 6));
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.m_108339_(this.sprites);
            this.f_107230_ = 1.0f - (float)this.f_107224_ / (float)this.f_107225_;
        }
        if (this.isInsideBlock(this.f_107208_)) {
            this.m_107274_();
        }
    }

    public float m_5902_(float partialTicks) {
        return this.size;
    }

    public int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    private boolean isInsideBlock(ClientLevel world) {
        BlockPos blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        BlockState state = world.m_8055_(blockPos);
        return !state.m_60795_();
    }

    public static class GunSparkParticleProvider
    implements ParticleProvider<GunSparkParticleData> {
        private final SpriteSet sprite;

        public GunSparkParticleProvider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(GunSparkParticleData data, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            GunSparkParticle particle = new GunSparkParticle(world, x, y, z, data.getSize(), this.sprite);
            particle.m_108339_(this.sprite);
            return particle;
        }
    }
}

