/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jaams.jaams_weaponry.registries.CustomParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class GunSparkParticleData
implements ParticleOptions {
    public static final Codec<GunSparkParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size))).apply((Applicative)instance, GunSparkParticleData::new));
    public static final ParticleOptions.Deserializer<GunSparkParticleData> DESERIALIZER = new ParticleOptions.Deserializer<GunSparkParticleData>(){

        public GunSparkParticleData fromCommand(ParticleType<GunSparkParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float size = Math.max(reader.readFloat(), 0.0f);
            return new GunSparkParticleData(size);
        }

        public GunSparkParticleData fromNetwork(ParticleType<GunSparkParticleData> type, FriendlyByteBuf buffer) {
            return new GunSparkParticleData(Math.max(buffer.readFloat(), 0.0f));
        }
    };
    private final float size;

    public GunSparkParticleData(float size) {
        this.size = Math.max(size, 0.0f);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)CustomParticles.GUN_SPARK_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.size);
    }

    public String m_5942_() {
        return String.format("%s %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.size));
    }

    public float getSize() {
        return this.size;
    }
}

