/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.jaams.jaams_weaponry.registries.CustomParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.registries.ForgeRegistries;

public class SmallWaveParticleData
implements ParticleOptions {
    public static final Codec<SmallWaveParticleData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r").forGetter(data -> Float.valueOf(data.r)), (App)Codec.FLOAT.fieldOf("g").forGetter(data -> Float.valueOf(data.g)), (App)Codec.FLOAT.fieldOf("b").forGetter(data -> Float.valueOf(data.b)), (App)Codec.FLOAT.fieldOf("size").forGetter(data -> Float.valueOf(data.size))).apply((Applicative)instance, SmallWaveParticleData::new));
    public static final ParticleOptions.Deserializer<SmallWaveParticleData> DESERIALIZER = new ParticleOptions.Deserializer<SmallWaveParticleData>(){

        public SmallWaveParticleData fromCommand(ParticleType<SmallWaveParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float g = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float b = Mth.m_14036_((float)reader.readFloat(), (float)0.0f, (float)1.0f);
            reader.expect(' ');
            float size = Math.max(reader.readFloat(), 0.0f);
            return new SmallWaveParticleData(r, g, b, size);
        }

        public SmallWaveParticleData fromNetwork(ParticleType<SmallWaveParticleData> type, FriendlyByteBuf buffer) {
            return new SmallWaveParticleData(Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Mth.m_14036_((float)buffer.readFloat(), (float)0.0f, (float)1.0f), Math.max(buffer.readFloat(), 0.0f));
        }
    };
    private final float r;
    private final float g;
    private final float b;
    private final float size;

    public SmallWaveParticleData(float r, float g, float b, float size) {
        this.r = Mth.m_14036_((float)r, (float)0.0f, (float)1.0f);
        this.g = Mth.m_14036_((float)g, (float)0.0f, (float)1.0f);
        this.b = Mth.m_14036_((float)b, (float)0.0f, (float)1.0f);
        this.size = Math.max(size, 0.0f);
    }

    public ParticleType<?> m_6012_() {
        return (ParticleType)CustomParticles.SMALL_WAVE_PARTICLE.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.r);
        buffer.writeFloat(this.g);
        buffer.writeFloat(this.b);
        buffer.writeFloat(this.size);
    }

    public String m_5942_() {
        return String.format("%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.size));
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getSize() {
        return this.size;
    }
}

