/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.potion;

import java.util.UUID;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ArchersGraceMobEffect
extends MobEffect {
    private static final UUID ATTACK_KNOCKBACK_UUID = UUID.fromString("19711849-330d-43f8-9e95-f35e9cb17efc");
    private static final UUID ATTACK_SPEED_UUID = UUID.fromString("936a6b7f-d414-4869-928e-e5728658970b");

    public ArchersGraceMobEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFF3300);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        double attackKnockbackBonus = 0.3 + (double)amplifier * 0.2;
        double attackSpeedBonus = 0.3 + (double)amplifier * 0.2;
        this.applyOrUpdateModifier(entity, Attributes.f_22282_, ATTACK_KNOCKBACK_UUID, "Archer Knockback", attackKnockbackBonus, AttributeModifier.Operation.ADDITION);
        this.applyOrUpdateModifier(entity, Attributes.f_22283_, ATTACK_SPEED_UUID, "Archer Attack Speed", attackSpeedBonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModUtils.playSound((Entity)entity, "jaams_weaponry:archers_grace_started");
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        this.removeModifier(entity, Attributes.f_22282_, ATTACK_KNOCKBACK_UUID);
        this.removeModifier(entity, Attributes.f_22283_, ATTACK_SPEED_UUID);
        ModUtils.playSound((Entity)entity, "jaams_weaponry:archers_grace_expires");
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void applyOrUpdateModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(uuid);
            instance.m_22118_(new AttributeModifier(uuid, name, value, operation));
        }
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(uuid);
        }
    }
}

