/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.potion;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class DepletionMobEffect
extends MobEffect {
    private static final UUID ATTACK_SPEED_UUID = UUID.fromString("8a5f7071-04a5-4a1f-9420-b94d8b2e58f5");
    private static final UUID MOVEMENT_SPEED_UUID = UUID.fromString("c5f92ad3-68eb-4f76-9732-1e8d40a6de78");
    private static final UUID ATTACK_DAMAGE_UUID = UUID.fromString("d3f4e6a2-9b7c-4c2e-a8f1-2c9b5d6e7f89");

    public DepletionMobEffect() {
        super(MobEffectCategory.HARMFUL, 0xFF66CC);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        double attackSpeedModifier = -0.2 - (double)amplifier * 0.1;
        double movementSpeedModifier = -0.2 - (double)amplifier * 0.1;
        double attackDamageModifier = -0.2 - (double)amplifier * 0.1;
        this.applyOrUpdateModifier(entity, Attributes.f_22283_, ATTACK_SPEED_UUID, "Depletion Attack Speed", attackSpeedModifier);
        this.applyOrUpdateModifier(entity, Attributes.f_22279_, MOVEMENT_SPEED_UUID, "Depletion Movement Speed", movementSpeedModifier);
        this.applyOrUpdateModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_UUID, "Depletion Attack Damage", attackDamageModifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        this.removeModifier(entity, Attributes.f_22283_, ATTACK_SPEED_UUID);
        this.removeModifier(entity, Attributes.f_22279_, MOVEMENT_SPEED_UUID);
        this.removeModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_UUID);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void applyOrUpdateModifier(LivingEntity entity, Attribute attribute, UUID uuid, String name, double value) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            AttributeModifier existingModifier = attributeInstance.m_22111_(uuid);
            if (existingModifier != null) {
                attributeInstance.m_22120_(uuid);
            }
            attributeInstance.m_22118_(new AttributeModifier(uuid, name, value, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, UUID uuid) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(uuid);
        }
    }
}

