/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.potion;

import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class IncapableMobEffect
extends MobEffect {
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("ff55bb82-24a3-4b6d-90f6-75b22d54bfeb");
    private static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("de5fc1e5-bff2-4956-9bf0-abbc511d5e2d");

    public IncapableMobEffect() {
        super(MobEffectCategory.HARMFUL, -12422244);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        double attackSpeedPenalty = -0.8 - (double)amplifier * 0.1;
        double attackDamagePenalty = -0.8 - (double)amplifier * 0.1;
        this.applyOrUpdateModifier(entity, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_ID, "Incapable Attack Speed", attackSpeedPenalty, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.applyOrUpdateModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_MODIFIER_ID, "Incapable Attack Damage", attackDamagePenalty, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        if (entity == null) {
            return;
        }
        this.removeModifier(entity, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_ID);
        this.removeModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_MODIFIER_ID);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void applyOrUpdateModifier(LivingEntity entity, Attribute attribute, UUID modifierId, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(modifierId);
            attributeInstance.m_22118_(new AttributeModifier(modifierId, name, value, operation));
        }
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, UUID modifierId) {
        AttributeInstance attributeInstance = entity.m_21051_(attribute);
        if (attributeInstance != null) {
            attributeInstance.m_22120_(modifierId);
        }
    }
}

