/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.potion;

import java.util.UUID;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class VigorousRageMobEffect
extends MobEffect {
    private static final UUID ATTACK_SPEED_MODIFIER_ID = UUID.fromString("7c7ba62d-c015-4b76-924f-5b6b200eac39");
    private static final UUID ATTACK_KNOCKBACK_MODIFIER_ID = UUID.fromString("d594fa72-d09b-4e2a-9f56-388ef4b5e279");
    private static final UUID MOVEMENT_SPEED_MODIFIER_ID = UUID.fromString("3176c3c5-487a-4657-92fb-dc66e9835290");

    public VigorousRageMobEffect() {
        super(MobEffectCategory.BENEFICIAL, -26368);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        double attackSpeedBonus = 0.3 + (double)amplifier * 0.1;
        double attackKnockbackBonus = 0.5 + (double)amplifier * 0.2;
        double movementSpeedBonus = 0.1 + (double)amplifier * 0.02;
        this.applyModifier(entity, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_ID, "vigorous_rage_attack_speed", attackSpeedBonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.applyModifier(entity, Attributes.f_22282_, ATTACK_KNOCKBACK_MODIFIER_ID, "vigorous_rage_knockback", attackKnockbackBonus, AttributeModifier.Operation.ADDITION);
        this.applyModifier(entity, Attributes.f_22279_, MOVEMENT_SPEED_MODIFIER_ID, "vigorous_rage_movement_speed", movementSpeedBonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
        ModUtils.playSound((Entity)entity, "jaams_weaponry:vigorous_rage_started");
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        if (entity == null) {
            return;
        }
        this.removeModifier(entity, Attributes.f_22283_, ATTACK_SPEED_MODIFIER_ID);
        this.removeModifier(entity, Attributes.f_22282_, ATTACK_KNOCKBACK_MODIFIER_ID);
        this.removeModifier(entity, Attributes.f_22279_, MOVEMENT_SPEED_MODIFIER_ID);
        ModUtils.playSound((Entity)entity, "jaams_weaponry:vigorous_rage_expires");
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void applyModifier(LivingEntity entity, Attribute attribute, UUID modifierId, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(modifierId);
        instance.m_22118_(new AttributeModifier(modifierId, name, value, operation));
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, UUID modifierId) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(modifierId);
        }
    }
}

