/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.potion;

import java.util.UUID;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public class WarriorsGraceMobEffect
extends MobEffect {
    private static final UUID ATTACK_DAMAGE_MODIFIER_ID = UUID.fromString("98d98663-b219-4cbc-b235-e08a690fe47a");
    private static final UUID KNOCKBACK_RESISTANCE_MODIFIER_ID = UUID.fromString("bee8e094-8892-49c8-873a-ca09234bbae9");

    public WarriorsGraceMobEffect() {
        super(MobEffectCategory.BENEFICIAL, -52480);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        if (entity == null) {
            return;
        }
        double attackBonus = 0.3 + (double)amplifier * 0.3;
        double knockbackBonus = 0.3 + (double)amplifier * 0.1;
        this.applyModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_MODIFIER_ID, "warrior1", attackBonus, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (entity instanceof Player) {
            this.applyModifier(entity, Attributes.f_22278_, KNOCKBACK_RESISTANCE_MODIFIER_ID, "warrior2", knockbackBonus, AttributeModifier.Operation.ADDITION);
        }
        ModUtils.playSound((Entity)entity, "jaams_weaponry:warrior_grace_started");
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        if (entity == null) {
            return;
        }
        this.removeModifier(entity, Attributes.f_22281_, ATTACK_DAMAGE_MODIFIER_ID);
        if (entity instanceof Player) {
            this.removeModifier(entity, Attributes.f_22278_, KNOCKBACK_RESISTANCE_MODIFIER_ID);
        }
        ModUtils.playSound((Entity)entity, "jaams_weaponry:warrior_grace_expires");
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    private void applyModifier(LivingEntity entity, Attribute attribute, UUID modifierId, String name, double value, AttributeModifier.Operation operation) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(modifierId);
        instance.m_22118_(new AttributeModifier(modifierId, name, value, operation));
    }

    private void removeModifier(LivingEntity entity, Attribute attribute, UUID modifierId) {
        AttributeInstance instance = entity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(modifierId);
        }
    }
}

