/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.properties;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class BlockingProperties {
    public final int cooldownTicks;
    public final double areaDamageMultiplier;
    public final double knockbackForce;
    public final double areaRange;
    public final double blockDamageReduction;
    public final int damagePerBlock;
    public final int damageOnStop;
    public final SoundEvent blockSound;
    public final float particleSize;
    public final float particleDistance;

    public BlockingProperties(Builder builder) {
        this.cooldownTicks = builder.cooldownTicks;
        this.areaDamageMultiplier = builder.areaDamageMultiplier;
        this.knockbackForce = builder.knockbackForce;
        this.areaRange = builder.areaRange;
        this.blockDamageReduction = builder.blockDamageReduction;
        this.damagePerBlock = builder.damagePerBlock;
        this.damageOnStop = builder.damageOnStop;
        this.blockSound = builder.blockSound;
        this.particleSize = builder.particleSize;
        this.particleDistance = builder.particleDistance;
    }

    public static class Builder {
        private int cooldownTicks = 20;
        private double areaDamageMultiplier = 0.5;
        private double knockbackForce = 0.4;
        private double areaRange = 1.5;
        private double blockDamageReduction = 0.85;
        private int damagePerBlock = 2;
        private int damageOnStop = 1;
        private SoundEvent blockSound = SoundEvents.f_12346_;
        private float particleSize = 0.65f;
        private float particleDistance = 1.2f;

        public Builder cooldownTicks(int ticks) {
            this.cooldownTicks = ticks;
            return this;
        }

        public Builder areaDamageMultiplier(double multiplier) {
            this.areaDamageMultiplier = multiplier;
            return this;
        }

        public Builder knockbackForce(double force) {
            this.knockbackForce = force;
            return this;
        }

        public Builder areaRange(double range) {
            this.areaRange = range;
            return this;
        }

        public Builder blockDamageReduction(double reduction) {
            this.blockDamageReduction = reduction;
            return this;
        }

        public Builder damagePerBlock(int damage) {
            this.damagePerBlock = damage;
            return this;
        }

        public Builder damageOnStop(int damage) {
            this.damageOnStop = damage;
            return this;
        }

        public Builder blockSound(SoundEvent sound) {
            this.blockSound = sound;
            return this;
        }

        public Builder particleSize(float size) {
            this.particleSize = size;
            return this;
        }

        public Builder particleDistance(float distance) {
            this.particleDistance = distance;
            return this;
        }

        public BlockingProperties build() {
            return new BlockingProperties(this);
        }
    }
}

