/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.properties;

import net.minecraftforge.fml.ModList;

public class EquipmentProperties {

    public static class EquipmentEntry {
        private final String mainHandItemId;
        private final String offHandItemId;
        private final String mainHandTag;
        private final String offHandTag;
        private final String modid;
        private final double spawnChance;
        private final float dropChance;
        private final int mainHandMinStack;
        private final int mainHandMaxStack;
        private final int offHandMinStack;
        private final int offHandMaxStack;

        public EquipmentEntry(String mainHand, double spawnChance, float dropChance, int minStack, int maxStack) {
            this(mainHand, "", spawnChance, dropChance, minStack, maxStack, 0, 0, "");
        }

        public EquipmentEntry(String mainHand, double spawnChance, float dropChance, int minStack, int maxStack, String modid) {
            this(mainHand, "", spawnChance, dropChance, minStack, maxStack, 0, 0, modid != null ? modid : "");
        }

        public EquipmentEntry(String mainHand, String offHand, double spawnChance, float dropChance, int mainHandMinStack, int mainHandMaxStack, int offHandMinStack, int offHandMaxStack) {
            this(mainHand, offHand, spawnChance, dropChance, mainHandMinStack, mainHandMaxStack, offHandMinStack, offHandMaxStack, "");
        }

        public EquipmentEntry(String mainHand, String offHand, double spawnChance, float dropChance, int mainHandMinStack, int mainHandMaxStack, int offHandMinStack, int offHandMaxStack, String modid) {
            String safeMainHand = mainHand != null ? mainHand : "";
            String safeOffHand = offHand != null ? offHand : "";
            this.mainHandItemId = safeMainHand.startsWith("#") ? "" : safeMainHand;
            this.offHandItemId = safeOffHand.startsWith("#") ? "" : safeOffHand;
            this.mainHandTag = safeMainHand.startsWith("#") ? safeMainHand.substring(1) : "";
            this.offHandTag = safeOffHand.startsWith("#") ? safeOffHand.substring(1) : "";
            this.modid = modid != null ? modid : "";
            this.spawnChance = spawnChance;
            this.dropChance = dropChance;
            this.mainHandMinStack = mainHandMinStack;
            this.mainHandMaxStack = mainHandMaxStack;
            this.offHandMinStack = offHandMinStack;
            this.offHandMaxStack = offHandMaxStack;
        }

        public String getMainHandItemId() {
            return this.mainHandItemId;
        }

        public String getOffHandItemId() {
            return this.offHandItemId;
        }

        public String getMainHandTag() {
            return this.mainHandTag;
        }

        public String getOffHandTag() {
            return this.offHandTag;
        }

        public double getSpawnChance() {
            return this.spawnChance;
        }

        public float getDropChance() {
            return this.dropChance;
        }

        public int getMainHandMinStack() {
            return this.mainHandMinStack;
        }

        public int getMainHandMaxStack() {
            return this.mainHandMaxStack;
        }

        public int getOffHandMinStack() {
            return this.offHandMinStack;
        }

        public int getOffHandMaxStack() {
            return this.offHandMaxStack;
        }

        public boolean isDualWield() {
            return !this.offHandItemId.isEmpty() || !this.offHandTag.isEmpty();
        }

        public String getModid() {
            return this.modid;
        }

        public boolean isModLoaded() {
            return this.modid.isEmpty() || ModList.get().isLoaded(this.modid);
        }
    }
}

