/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.spawn;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.jaams.jaams_weaponry.handler.mechanics.EntityEquipmentHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.properties.EquipmentProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrownedSpawn
extends EntityEquipmentHandler {
    private static final List<EquipmentProperties.EquipmentEntry> LOW_TIER_WEAPONS = DrownedSpawn.buildLowTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> MID_TIER_WEAPONS = DrownedSpawn.buildMidTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> HIGH_TIER_WEAPONS = DrownedSpawn.buildHighTierWeapons();
    private static final double EQUIP_CHANCE_EASY = 0.15;
    private static final double EQUIP_CHANCE_NORMAL = 0.25;
    private static final double EQUIP_CHANCE_HARD = 0.35;
    private static final String EQUIPPED_TAG = "Equipped";

    private static List<EquipmentProperties.EquipmentEntry> buildLowTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:stone_sword", 0.3, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_dagger", 0.3, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:fishing_rod", 0.25, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_spear", 0.3, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:sharp_stone", 0.3, 0.03f, 1, 6));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_dagger", "jaams_weaponry:sharp_stone", 0.1, 0.02f, 1, 1, 1, 6));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildMidTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:trident", 0.05, 0.02f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_spear", 0.15, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:stone_axe", 0.15, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_machete", 0.15, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:smoke_bomb", 0.03, 0.01f, 3, 16));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_machete", "jaams_weaponry:sharp_stone", 0.1, 0.02f, 1, 1, 3, 16));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildHighTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_claw", 0.25, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_katar", 0.25, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_buster_sword", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:fishing_rod", 0.25, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_claw", "jaams_weaponry:stone_claw", 0.1, 0.05f, 1, 1, 1, 1));
        return List.copyOf(weapons);
    }

    @Override
    protected void applyCustomNBT(ItemStack stack, Difficulty difficulty, Random random) {
        if (stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            stack.m_41721_(random.nextInt(maxDamage));
        }
        if (!stack.m_41753_() && stack.m_41792_() && difficulty != Difficulty.EASY) {
            String itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_();
            boolean isAftermathEligible = itemPath.contains("spear") || itemPath.contains("cleaver") || itemPath.contains("axe");
            boolean isTrident = itemPath.equals("trident");
            boolean isFishingRod = itemPath.equals("fishing_rod");
            boolean isConventionalWeapon = true;
            double enchantChance = switch (difficulty) {
                case Difficulty.NORMAL -> 0.25;
                case Difficulty.HARD -> 0.35;
                default -> 0.0;
            };
            int maxEnchantments = difficulty == Difficulty.HARD ? 3 : 2;
            List<Enchantment> validEnchantments = EnchantmentHelper.m_44817_((int)1, (ItemStack)stack, (boolean)false).stream().map(instance -> instance.f_44947_).filter(enchantment -> enchantment.m_6081_(stack)).toList();
            ArrayList<Enchantment> customEnchantments = new ArrayList<Enchantment>();
            if (isConventionalWeapon) {
                if (((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get());
                }
                if (((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get());
                }
            }
            if (isAftermathEligible && ((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()).m_6081_(stack)) {
                customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get());
            }
            if (isTrident) {
                if (Enchantments.f_44955_.m_6081_(stack)) {
                    customEnchantments.add(Enchantments.f_44955_);
                }
                if (Enchantments.f_44956_.m_6081_(stack)) {
                    customEnchantments.add(Enchantments.f_44956_);
                }
            }
            if (isFishingRod) {
                // empty if block
            }
            if (!(validEnchantments = Stream.concat(validEnchantments.stream(), customEnchantments.stream()).filter(enchantment -> enchantment.m_6081_(stack)).toList()).isEmpty() && random.nextDouble() < enchantChance) {
                ArrayList<Enchantment> selectedEnchantments = new ArrayList<Enchantment>();
                int enchantCount = random.nextInt(maxEnchantments) + 1;
                ArrayList<Enchantment> availableEnchantments = new ArrayList<Enchantment>(validEnchantments);
                for (int i = 0; i < enchantCount && !availableEnchantments.isEmpty(); ++i) {
                    Enchantment enchantment2 = (Enchantment)availableEnchantments.get(random.nextInt(availableEnchantments.size()));
                    boolean isCompatible = selectedEnchantments.stream().allMatch(selected -> selected.m_44695_(enchantment2));
                    if (isCompatible) {
                        selectedEnchantments.add(enchantment2);
                        int level = switch (difficulty) {
                            case Difficulty.NORMAL -> random.nextInt(enchantment2.m_6586_() / 2 + 1) + 1;
                            case Difficulty.HARD -> random.nextInt(enchantment2.m_6586_()) + 1;
                            default -> 1;
                        };
                        stack.m_41663_(enchantment2, Math.min(level, enchantment2.m_6586_()));
                        availableEnchantments.removeIf(e -> !e.m_44695_(enchantment2));
                        continue;
                    }
                    availableEnchantments.remove(enchantment2);
                }
            }
            if (difficulty == Difficulty.HARD && isTrident && Enchantments.f_44955_.m_6081_(stack) && random.nextDouble() < 0.5) {
                int loyaltyLevel = random.nextInt(Enchantments.f_44955_.m_6586_()) + 1;
                stack.m_41663_(Enchantments.f_44955_, loyaltyLevel);
            }
        }
    }

    @Override
    protected double getEquipChance(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> 0.15;
            case Difficulty.NORMAL -> 0.25;
            case Difficulty.HARD -> 0.35;
            default -> 0.0;
        };
    }

    @Override
    protected List<EquipmentProperties.EquipmentEntry> getEquipmentList(Difficulty difficulty) {
        List<EquipmentProperties.EquipmentEntry> entries = switch (difficulty) {
            case Difficulty.EASY -> LOW_TIER_WEAPONS;
            case Difficulty.NORMAL -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList<EquipmentProperties.EquipmentEntry>();
                list.addAll(this.adjustSpawnChances(LOW_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                yield list;
            }
            case Difficulty.HARD -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList();
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(HIGH_TIER_WEAPONS, 0.5));
                yield list;
            }
            default -> List.of();
        };
        return entries.stream().filter(EquipmentProperties.EquipmentEntry::isModLoaded).toList();
    }

    @SubscribeEvent
    public static void onDrownedJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Drowned)) {
            return;
        }
        Drowned drowned = (Drowned)entity;
        if (drowned.m_8077_()) {
            return;
        }
        if (drowned.m_6162_()) {
            return;
        }
        CompoundTag entityData = drowned.getPersistentData();
        if (entityData.m_128471_(EQUIPPED_TAG)) {
            return;
        }
        Level level = event.getLevel();
        Difficulty difficulty = level.m_46791_();
        if (difficulty == null) {
            return;
        }
        if (drowned.f_19797_ > 20) {
            return;
        }
        Random random = new Random(level.m_213780_().m_188505_());
        new DrownedSpawn().equipEntity((Mob)drowned, level, difficulty, random);
        entityData.m_128379_(EQUIPPED_TAG, true);
    }
}

