/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.spawn;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.jaams.jaams_weaponry.handler.mechanics.EntityEquipmentHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.properties.EquipmentProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StraySpawn
extends EntityEquipmentHandler {
    private static final List<EquipmentProperties.EquipmentEntry> LOW_TIER_WEAPONS = StraySpawn.buildLowTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> MID_TIER_WEAPONS = StraySpawn.buildMidTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> HIGH_TIER_WEAPONS = StraySpawn.buildHighTierWeapons();
    private static final double EQUIP_CHANCE_EASY = 1.0;
    private static final double EQUIP_CHANCE_NORMAL = 1.0;
    private static final double EQUIP_CHANCE_HARD = 1.0;
    private static final String EQUIPPED_TAG = "Equipped";

    private static List<EquipmentProperties.EquipmentEntry> buildLowTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:short_bow", 0.5, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:flat_bow", 0.5, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", 0.5, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:compound_bow", 0.1, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_kama", "jaams_weaponry:iron_kama", 0.02, 0.05f, 1, 1, 3, 16));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:short_bow", "jaams_weaponry:gauntlet", 0.02, 0.05f, 1, 1, 3, 16));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildMidTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:short_bow", 0.3, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:flat_bow", 0.3, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", 0.3, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_boomerang", 0.15, 0.08f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scythe", 0.04, 0.08f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scattergun", 0.02, 0.08f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", "minecraft:tipped_arrow", 0.05, 0.05f, 1, 1, 3, 16));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", "jaams_weaponry:gauntlet", 0.05, 0.05f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scattergun", "jaams_weaponry:heavy_bullet", 0.02, 0.05f, 1, 1, 6, 46));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildHighTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", 0.25, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:compound_bow", 0.25, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_boomerang", 0.15, 0.08f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scythe", 0.04, 0.08f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_spear", 0.04, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scattergun", 0.02, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:short_bow", "minecraft:tipped_arrow", 0.05, 0.05f, 1, 1, 3, 56));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:hunters_bow", "minecraft:tipped_arrow", 0.05, 0.05f, 1, 1, 3, 56));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:compound_bow", "minecraft:tipped_arrow", 0.05, 0.05f, 1, 1, 3, 56));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scattergun", "jaams_weaponry:sharp_bullet", 0.02, 0.05f, 1, 1, 3, 56));
        return List.copyOf(weapons);
    }

    @Override
    protected void applyCustomNBT(ItemStack stack, Difficulty difficulty, Random random) {
        boolean isGauntlet = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_().equals("gauntlet");
        if (isGauntlet && random.nextDouble() < 0.5) {
            CompoundTag tag = stack.m_41784_();
            int color = random.nextInt(0xFFFFFF);
            tag.m_128405_("color", color);
        }
        if (stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            stack.m_41721_(random.nextInt(maxDamage));
        }
        if (!stack.m_41753_() && stack.m_41792_() && difficulty != Difficulty.EASY) {
            List<Enchantment> combinedEnchantments;
            String itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_();
            boolean isAftermathEligible = itemPath.contains("spear") || itemPath.contains("cleaver") || itemPath.contains("broom") || itemPath.contains("axe");
            boolean isConventionalWeapon = !itemPath.contains("broom");
            double enchantChance = switch (difficulty) {
                case Difficulty.NORMAL -> 0.25;
                case Difficulty.HARD -> 0.35;
                default -> 0.0;
            };
            int maxEnchantments = difficulty == Difficulty.HARD ? 3 : 2;
            List<Enchantment> validEnchantments = EnchantmentHelper.m_44817_((int)1, (ItemStack)stack, (boolean)false).stream().map(instance -> instance.f_44947_).filter(enchantment -> enchantment.m_6081_(stack)).toList();
            ArrayList<Enchantment> customEnchantments = new ArrayList<Enchantment>();
            if (isConventionalWeapon) {
                if (((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get());
                }
                if (((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get());
                }
            }
            if (isAftermathEligible && ((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()).m_6081_(stack)) {
                customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get());
            }
            if (!(combinedEnchantments = Stream.concat(validEnchantments.stream(), customEnchantments.stream()).filter(enchantment -> enchantment.m_6081_(stack)).toList()).isEmpty() && random.nextDouble() < enchantChance) {
                ArrayList<Enchantment> selectedEnchantments = new ArrayList<Enchantment>();
                int enchantCount = random.nextInt(maxEnchantments) + 1;
                ArrayList<Enchantment> availableEnchantments = new ArrayList<Enchantment>(combinedEnchantments);
                for (int i = 0; i < enchantCount && !availableEnchantments.isEmpty(); ++i) {
                    Enchantment enchantment2 = (Enchantment)availableEnchantments.get(random.nextInt(availableEnchantments.size()));
                    boolean isCompatible = selectedEnchantments.stream().allMatch(selected -> selected.m_44695_(enchantment2));
                    if (isCompatible) {
                        selectedEnchantments.add(enchantment2);
                        int level = switch (difficulty) {
                            case Difficulty.NORMAL -> random.nextInt(enchantment2.m_6586_() / 2 + 1) + 1;
                            case Difficulty.HARD -> random.nextInt(enchantment2.m_6586_()) + 1;
                            default -> 1;
                        };
                        stack.m_41663_(enchantment2, Math.min(level, enchantment2.m_6586_()));
                        availableEnchantments.removeIf(e -> !e.m_44695_(enchantment2));
                        continue;
                    }
                    availableEnchantments.remove(enchantment2);
                }
            }
            if (difficulty == Difficulty.HARD) {
                boolean isLoyaltyEligible;
                boolean bl = isLoyaltyEligible = itemPath.contains("spear") || itemPath.contains("cleaver") || itemPath.contains("broom");
                if (isLoyaltyEligible && Enchantments.f_44955_.m_6081_(stack) && random.nextDouble() < 0.5) {
                    int loyaltyLevel = random.nextInt(Enchantments.f_44955_.m_6586_()) + 1;
                    stack.m_41663_(Enchantments.f_44955_, loyaltyLevel);
                }
            }
        }
        if (stack.m_150930_(Items.f_42738_)) {
            Potion[] potions = new Potion[]{Potions.f_43593_, Potions.f_43615_};
            Potion selectedPotion = potions[random.nextInt(potions.length)];
            PotionUtils.m_43549_((ItemStack)stack, (Potion)selectedPotion);
        }
    }

    @Override
    protected double getEquipChance(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> 1.0;
            case Difficulty.NORMAL -> 1.0;
            case Difficulty.HARD -> 1.0;
            default -> 0.0;
        };
    }

    @Override
    protected List<EquipmentProperties.EquipmentEntry> getEquipmentList(Difficulty difficulty) {
        List<EquipmentProperties.EquipmentEntry> entries = switch (difficulty) {
            case Difficulty.EASY -> LOW_TIER_WEAPONS;
            case Difficulty.NORMAL -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList<EquipmentProperties.EquipmentEntry>();
                list.addAll(this.adjustSpawnChances(LOW_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                yield list;
            }
            case Difficulty.HARD -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList();
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(HIGH_TIER_WEAPONS, 0.5));
                yield list;
            }
            default -> List.of();
        };
        return entries.stream().filter(EquipmentProperties.EquipmentEntry::isModLoaded).toList();
    }

    @SubscribeEvent
    public static void onStrayJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Stray)) {
            return;
        }
        Stray stray = (Stray)entity;
        if (stray.m_8077_()) {
            return;
        }
        if (stray.m_6162_()) {
            return;
        }
        CompoundTag entityData = stray.getPersistentData();
        if (entityData.m_128471_(EQUIPPED_TAG)) {
            return;
        }
        Level level = event.getLevel();
        Difficulty difficulty = level.m_46791_();
        if (difficulty == null) {
            return;
        }
        if (stray.f_19797_ > 20) {
            return;
        }
        Random random = new Random(level.m_213780_().m_188505_());
        new StraySpawn().equipEntity((Mob)stray, level, difficulty, random);
        entityData.m_128379_(EQUIPPED_TAG, true);
    }
}

