/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.spawn;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.jaams.jaams_weaponry.handler.mechanics.EntityEquipmentHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModEnchantments;
import net.jaams.jaams_weaponry.properties.EquipmentProperties;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="jaams_weaponry", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ZombieSpawn
extends EntityEquipmentHandler {
    private static final List<EquipmentProperties.EquipmentEntry> LOW_TIER_WEAPONS = ZombieSpawn.buildLowTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> MID_TIER_WEAPONS = ZombieSpawn.buildMidTierWeapons();
    private static final List<EquipmentProperties.EquipmentEntry> HIGH_TIER_WEAPONS = ZombieSpawn.buildHighTierWeapons();
    private static final double EQUIP_CHANCE_EASY = 0.15;
    private static final double EQUIP_CHANCE_NORMAL = 0.25;
    private static final double EQUIP_CHANCE_HARD = 0.35;
    private static final String EQUIPPED_TAG = "Equipped";

    private static List<EquipmentProperties.EquipmentEntry> buildLowTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:wooden_sword", 0.12, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:wooden_axe", 0.12, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:stone_sword", 0.08, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:stone_axe", 0.08, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:gauntlet", 0.12, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:wooden_dagger", 0.12, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_dagger", 0.12, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:wooden_knuckle", 0.08, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_knuckle", 0.05, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_machete", 0.05, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_claw", 0.05, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:wooden_ring", 0.05, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_cleaver", 0.05, 0.03f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:sharp_stone", 0.04, 0.03f, 1, 6));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:rustic_whip", 0.04, 0.01f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("#jaams_weaponry:brooms", 0.22, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:gauntlet", "jaams_weaponry:gauntlet", 0.01, 0.05f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:stone_claw", "jaams_weaponry:stone_claw", 0.05, 0.01f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:wooden_knuckle", "jaams_weaponry:wooden_knuckle", 0.01, 0.05f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:wooden_dagger", "jaams_weaponry:stone_dagger", 0.01, 0.02f, 1, 1, 1, 1));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildMidTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:iron_sword", 0.12, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:iron_axe", 0.12, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:golden_sword", 0.06, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_dagger", 0.12, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_dagger", 0.08, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_knuckle", 0.08, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_claw", 0.05, 0.01f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_ring", 0.05, 0.01f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_machete", 0.08, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_spear", 0.06, 0.06f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_katana", 0.04, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_butterfly_sword", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_longsword", 0.03, 0.06f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:sharp_stone", 0.05, 0.03f, 3, 16));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:smoke_bomb", 0.03, 0.01f, 3, 16));
        weapons.add(new EquipmentProperties.EquipmentEntry("#jaams_weaponry:brooms", 0.08, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:gauntlet", "jaams_weaponry:broom", 0.04, 0.04f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_dagger", "jaams_weaponry:iron_dagger_reverse", 0.05, 0.05f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_knuckle", "jaams_weaponry:iron_knuckle", 0.04, 0.04f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_knuckle", "jaams_weaponry:golden_knuckle", 0.04, 0.04f, 1, 1, 1, 1));
        return List.copyOf(weapons);
    }

    private static List<EquipmentProperties.EquipmentEntry> buildHighTierWeapons() {
        ArrayList<EquipmentProperties.EquipmentEntry> weapons = new ArrayList<EquipmentProperties.EquipmentEntry>();
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_broadsword", 0.06, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_hook_sword", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_zweihander", 0.06, 0.06f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_greatsword", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_twinblade", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_greathammer", 0.03, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_buster_sword", 0.02, 0.12f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_scattergun", 0.01, 0.01f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_greathammer", 0.04, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_greatsword", 0.05, 0.05f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_longsword", 0.05, 0.06f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_butterfly_sword", 0.02, 0.12f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:diamond_sword", 0.04, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("minecraft:diamond_axe", 0.04, 0.1f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_dagger", 0.05, 0.15f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_claw", 0.03, 0.0f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_ring", 0.03, 0.0f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_hammer", 0.01, 0.0f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_buster_sword", 0.01, 0.0f, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_spear", "jaams_weaponry:gauntlet", 0.04, 0.04f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_claw", "jaams_weaponry:iron_ring", 0.05, 0.05f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:diamond_knuckle", "jaams_weaponry:diamond_knuckle", 0.02, 0.1f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:golden_butterfly_sword", "jaams_weaponry:golden_butterfly_sword", 0.02, 0.1f, 1, 1, 1, 1));
        weapons.add(new EquipmentProperties.EquipmentEntry("jaams_weaponry:iron_katana", "jaams_weaponry:smoke_bomb", 0.04, 0.1f, 1, 1, 6, 16));
        return List.copyOf(weapons);
    }

    @Override
    protected void applyCustomNBT(ItemStack stack, Difficulty difficulty, Random random) {
        boolean isGauntlet = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_().equals("gauntlet");
        if (isGauntlet && random.nextDouble() < 0.5) {
            CompoundTag tag = stack.m_41784_();
            int color = random.nextInt(0xFFFFFF);
            tag.m_128405_("color", color);
        }
        if (stack.m_41763_()) {
            int maxDamage = stack.m_41776_();
            stack.m_41721_(random.nextInt(maxDamage));
        }
        if (!stack.m_41753_() && stack.m_41792_() && difficulty != Difficulty.EASY) {
            String itemPath = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).m_135815_();
            boolean isAftermathEligible = itemPath.contains("spear") || itemPath.contains("cleaver") || itemPath.contains("broom") || itemPath.contains("axe");
            boolean isConventionalWeapon = !itemPath.contains("broom");
            double enchantChance = switch (difficulty) {
                case Difficulty.NORMAL -> 0.25;
                case Difficulty.HARD -> 0.35;
                default -> 0.0;
            };
            int maxEnchantments = difficulty == Difficulty.HARD ? 3 : 2;
            List<Enchantment> validEnchantments = EnchantmentHelper.m_44817_((int)1, (ItemStack)stack, (boolean)false).stream().map(instance -> instance.f_44947_).filter(enchantment -> enchantment.m_6081_(stack)).toList();
            ArrayList<Enchantment> customEnchantments = new ArrayList<Enchantment>();
            if (isConventionalWeapon) {
                if (((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.SECURE_GRIP.get());
                }
                if (((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get()).m_6081_(stack)) {
                    customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.OVERDRIVE.get());
                }
            }
            if (isAftermathEligible && ((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get()).m_6081_(stack)) {
                customEnchantments.add((Enchantment)JaamsWeaponryModEnchantments.AFTERMATH.get());
            }
            if (!(validEnchantments = Stream.concat(validEnchantments.stream(), customEnchantments.stream()).filter(enchantment -> enchantment.m_6081_(stack)).toList()).isEmpty() && random.nextDouble() < enchantChance) {
                ArrayList<Enchantment> selectedEnchantments = new ArrayList<Enchantment>();
                int enchantCount = random.nextInt(maxEnchantments) + 1;
                ArrayList<Enchantment> availableEnchantments = new ArrayList<Enchantment>(validEnchantments);
                for (int i = 0; i < enchantCount && !availableEnchantments.isEmpty(); ++i) {
                    Enchantment enchantment2 = (Enchantment)availableEnchantments.get(random.nextInt(availableEnchantments.size()));
                    boolean isCompatible = selectedEnchantments.stream().allMatch(selected -> selected.m_44695_(enchantment2));
                    if (isCompatible) {
                        selectedEnchantments.add(enchantment2);
                        int level = switch (difficulty) {
                            case Difficulty.NORMAL -> random.nextInt(enchantment2.m_6586_() / 2 + 1) + 1;
                            case Difficulty.HARD -> random.nextInt(enchantment2.m_6586_()) + 1;
                            default -> 1;
                        };
                        stack.m_41663_(enchantment2, Math.min(level, enchantment2.m_6586_()));
                        availableEnchantments.removeIf(e -> !e.m_44695_(enchantment2));
                        continue;
                    }
                    availableEnchantments.remove(enchantment2);
                }
            }
            if (difficulty == Difficulty.HARD) {
                boolean isLoyaltyEligible;
                boolean bl = isLoyaltyEligible = itemPath.contains("spear") || itemPath.contains("cleaver") || itemPath.contains("broom");
                if (isLoyaltyEligible && Enchantments.f_44955_.m_6081_(stack) && random.nextDouble() < 0.5) {
                    int loyaltyLevel = random.nextInt(Enchantments.f_44955_.m_6586_()) + 1;
                    stack.m_41663_(Enchantments.f_44955_, loyaltyLevel);
                }
            }
        }
    }

    @Override
    protected double getEquipChance(Difficulty difficulty) {
        return switch (difficulty) {
            case Difficulty.EASY -> 0.15;
            case Difficulty.NORMAL -> 0.25;
            case Difficulty.HARD -> 0.35;
            default -> 0.0;
        };
    }

    @Override
    protected List<EquipmentProperties.EquipmentEntry> getEquipmentList(Difficulty difficulty) {
        List<EquipmentProperties.EquipmentEntry> entries = switch (difficulty) {
            case Difficulty.EASY -> LOW_TIER_WEAPONS;
            case Difficulty.NORMAL -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList<EquipmentProperties.EquipmentEntry>();
                list.addAll(this.adjustSpawnChances(LOW_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                yield list;
            }
            case Difficulty.HARD -> {
                ArrayList<EquipmentProperties.EquipmentEntry> list = new ArrayList();
                list.addAll(this.adjustSpawnChances(MID_TIER_WEAPONS, 0.5));
                list.addAll(this.adjustSpawnChances(HIGH_TIER_WEAPONS, 0.5));
                yield list;
            }
            default -> List.of();
        };
        return entries.stream().filter(EquipmentProperties.EquipmentEntry::isModLoaded).toList();
    }

    @SubscribeEvent
    public static void onZombieJoinLevel(EntityJoinLevelEvent event) {
        Zombie zombie;
        Entity entity = event.getEntity();
        if (!(entity instanceof Zombie) || (zombie = (Zombie)entity) instanceof Drowned || zombie instanceof Husk || zombie instanceof ZombifiedPiglin) {
            return;
        }
        if (zombie.m_8077_()) {
            return;
        }
        if (zombie.m_6162_()) {
            return;
        }
        CompoundTag entityData = zombie.getPersistentData();
        if (entityData.m_128471_(EQUIPPED_TAG)) {
            return;
        }
        Level level = event.getLevel();
        Difficulty difficulty = level.m_46791_();
        if (difficulty == null) {
            return;
        }
        if (zombie.f_19797_ > 20) {
            return;
        }
        Random random = new Random(level.m_213780_().m_188505_());
        new ZombieSpawn().equipEntity((Mob)zombie, level, difficulty, random);
        entityData.m_128379_(EQUIPPED_TAG, true);
    }
}

