/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.util;

import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.item.GreatCrossbowItem;
import net.jaams.jaams_weaponry.item.HuntersCrossbowItem;
import net.jaams.jaams_weaponry.item.NunchakuItem;
import net.jaams.jaams_weaponry.item.RoyalCrossbowItem;
import net.jaams.jaams_weaponry.item.StakeCrossbowItem;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModItemProperties {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.HUNTERS_BOW.get(), "pull", "pulling", 25.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.COMPOUND_BOW.get(), "pull", "pulling", 40.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.FLAT_BOW.get(), "pull", "pulling", 35.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.SHORT_BOW.get(), "pull", "pulling", 20.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.STONE_SLINGSHOT.get(), "pull", "pulling", 20.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.WOODEN_SLINGSHOT.get(), "pull", "pulling", 20.0f);
            ModItemProperties.makeBow((Item)JaamsWeaponryModItems.ROYAL_BOW.get(), "pull", "pulling", 25.0f);
            ModItemProperties.makeHuntersCrossbow((Item)JaamsWeaponryModItems.HUNTERS_CROSSBOW.get(), "pull", "pulling", "charged", "firework");
            ModItemProperties.makeStakeCrossbow((Item)JaamsWeaponryModItems.STAKE_CROSSBOW.get(), "pull", "pulling", "charged");
            ModItemProperties.makeGreatCrossbow((Item)JaamsWeaponryModItems.GREAT_CROSSBOW.get(), "pull", "pulling", "charged", "firework");
            ModItemProperties.makeRoyalCrossbow((Item)JaamsWeaponryModItems.ROYAL_CROSSBOW.get(), "pull", "pulling", "charged", "firework");
            ModItemProperties.makeNunchaku((Item)JaamsWeaponryModItems.NUNCHAKU.get(), "nunchaku_pulling");
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.WOODEN_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.STONE_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.IRON_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.GOLDEN_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.DIAMOND_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.NETHERITE_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            if (ModList.get().isLoaded("cavesanddepths") || ModList.get().isLoaded("oooh_pinky") || ModList.get().isLoaded("justrosegold")) {
                ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.ROSEGOLD_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            }
            if (ModList.get().isLoaded("jaams_shinerite")) {
                ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.SHINERITE_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            }
            if (ModList.get().isLoaded("majruszsdifficulty")) {
                ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.ENDERIUM_KATANA.get(), "weapon_skin", WeaponType.KATANA);
            }
            ModItemProperties.makeWeaponSkin((Item)JaamsWeaponryModItems.HUNTERS_BOOMERANG.get(), "weapon_skin", WeaponType.BOOMERANG);
        });
    }

    private static void makeNunchaku(Item item, String propertyName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("jaams_weaponry:" + propertyName), (stack, clientLevel, living, k) -> {
            CompoundTag nbt = stack.m_41784_();
            String skin = nbt.m_128461_("WeaponSkin").toLowerCase();
            String displayName = stack.m_41611_().getString().toLowerCase();
            if (living == null) {
                return ModItemProperties.getSkinValue(skin, displayName, 2.0f, 4.0f, 0.0f);
            }
            if (living instanceof Player) {
                Player player = (Player)living;
                return ModItemProperties.handlePlayerNunchaku(player, stack, skin, displayName);
            }
            if (living instanceof Mob) {
                Mob mob = (Mob)living;
                return ModItemProperties.handleMobNunchaku(mob, stack, skin, displayName);
            }
            return ModItemProperties.getSkinValue(skin, displayName, 2.0f, 4.0f, 0.0f);
        });
    }

    private static float handlePlayerNunchaku(Player player, ItemStack stack, String skin, String displayName) {
        if (ModUtils.hasRestrictedEffect((LivingEntity)player)) {
            return ModItemProperties.getSkinValue(skin, displayName, 2.0f, 4.0f, 0.0f);
        }
        boolean isHoldingNunchaku = player.m_21205_() == stack || player.m_21206_() == stack;
        boolean isSwinging = player.f_20913_ > 0 && player.f_20912_ != null && (player.f_20912_ == InteractionHand.MAIN_HAND && player.m_21205_() == stack || player.f_20912_ == InteractionHand.OFF_HAND && player.m_21206_() == stack) && player.m_36403_(0.0f) >= 0.5f && player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20154_().m_82490_(6.5)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() != HitResult.Type.BLOCK;
        boolean isRidingActive = false;
        Entity entity = player.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            boolean isVehicleMoving = vehicle.m_20184_().m_82553_() > 0.15;
            boolean isVehicleSprinting = vehicle.m_20142_();
            isRidingActive = isHoldingNunchaku && (isVehicleMoving || isVehicleSprinting);
        }
        boolean isActive = !(!isHoldingNunchaku || player.m_36335_().m_41519_(stack.m_41720_()) || player.m_6117_() && player.m_21211_() != stack && !(player.m_21211_().m_41720_() instanceof NunchakuItem) || (!player.m_6117_() || player.m_21211_() != stack && !(player.m_21211_().m_41720_() instanceof NunchakuItem)) && !player.m_20142_() && !isSwinging && !isRidingActive);
        return ModItemProperties.getSkinValue(skin, displayName, isActive ? 3.0f : 2.0f, isActive ? 5.0f : 4.0f, isActive ? 1.0f : 0.0f);
    }

    private static float handleMobNunchaku(Mob mob, ItemStack stack, String skin, String displayName) {
        if (mob.m_21525_() || ModUtils.hasRestrictedEffect((LivingEntity)mob)) {
            return ModItemProperties.getSkinValue(skin, displayName, 2.0f, 4.0f, 0.0f);
        }
        boolean isHoldingNunchaku = mob.m_21205_() == stack || mob.m_21206_() == stack;
        boolean isSwinging = mob.f_20913_ > 0 && mob.f_20912_ != null && (mob.f_20912_ == InteractionHand.MAIN_HAND && mob.m_21205_() == stack || mob.f_20912_ == InteractionHand.OFF_HAND && mob.m_21206_() == stack);
        boolean isMoving = mob.m_20184_().m_82553_() > 0.06 && isHoldingNunchaku;
        boolean isRidingActive = false;
        Entity entity = mob.m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity;
            boolean isVehicleMoving = vehicle.m_20184_().m_82553_() > 0.15;
            boolean isVehicleSprinting = vehicle.m_20142_();
            boolean bl = isRidingActive = isHoldingNunchaku && (isVehicleMoving || isVehicleSprinting);
        }
        if (isMoving || isRidingActive) {
            return ModItemProperties.getSkinValue(skin, displayName, 3.0f, 5.0f, 1.0f);
        }
        boolean isActive = isHoldingNunchaku && (mob.m_6117_() && (mob.m_21211_() == stack || mob.m_21211_().m_41720_() instanceof NunchakuItem) || mob.m_20142_() || isSwinging);
        return ModItemProperties.getSkinValue(skin, displayName, isActive ? 3.0f : 2.0f, isActive ? 5.0f : 4.0f, isActive ? 1.0f : 0.0f);
    }

    private static float getSkinValue(String skin, String displayName, float rockLeeValue, float michaelangeloValue, float defaultValue) {
        if (skin.equals("rock_lee") || displayName.equalsIgnoreCase("[rock lee]")) {
            return rockLeeValue;
        }
        if (skin.equals("michaelangelo") || displayName.equalsIgnoreCase("[michaelangelo]")) {
            return michaelangeloValue;
        }
        return defaultValue;
    }

    private static void makeWeaponSkin(Item item, String propertyName, WeaponType weaponType) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("jaams_weaponry:" + propertyName), (stack, clientLevel, living, k) -> {
            CompoundTag nbt = stack.m_41784_();
            String skin = nbt.m_128461_("WeaponSkin").toLowerCase();
            switch (weaponType) {
                case KATANA: {
                    if (skin.equals("rengoku")) {
                        return 1.0f;
                    }
                    if (skin.equals("mitsuri")) {
                        return 2.0f;
                    }
                    if (skin.equals("zenitsu")) {
                        return 3.0f;
                    }
                    if (skin.equals("inosuke")) {
                        return 4.0f;
                    }
                    String displayName = stack.m_41611_().getString().toLowerCase();
                    if (displayName.equalsIgnoreCase("[rengoku]")) {
                        return 1.0f;
                    }
                    if (displayName.equalsIgnoreCase("[mitsuri]")) {
                        return 2.0f;
                    }
                    if (displayName.equalsIgnoreCase("[zenitsu]")) {
                        return 3.0f;
                    }
                    if (displayName.equalsIgnoreCase("[inosuke]")) {
                        return 4.0f;
                    }
                    return 0.0f;
                }
                case BOOMERANG: {
                    if (skin.equals("sokka")) {
                        return 1.0f;
                    }
                    if (stack.m_41611_().getString().equalsIgnoreCase("[sokka]")) {
                        return 1.0f;
                    }
                    return 0.0f;
                }
            }
            return 0.0f;
        });
    }

    private static void makeBow(Item item, String propertyName, String propertyPullingName, float maxPull) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (itemStack, clientWorld, livingEntity, i) -> {
            if (livingEntity == null) {
                return 0.0f;
            }
            return livingEntity.m_21211_() != itemStack ? 0.0f : (float)(itemStack.m_41779_() - livingEntity.m_21212_()) / maxPull;
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyPullingName), (itemStack, clientWorld, livingEntity, i) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
    }

    private static void makeHuntersCrossbow(Item item, String propertyName, String propertyPullingName, String propertyChargedName, String propertyFireworkName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (stack, clientLevel, living, k) -> {
            if (living == null) {
                return 0.0f;
            }
            return HuntersCrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / (float)HuntersCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyPullingName), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == stack && !HuntersCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyChargedName), (stack, clientLevel, living, k) -> living != null && HuntersCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyFireworkName), (stack, clientLevel, living, k) -> living != null && HuntersCrossbowItem.m_40932_((ItemStack)stack) && HuntersCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }

    private static void makeStakeCrossbow(Item item, String propertyName, String propertyPullingName, String propertyChargedName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (stack, clientLevel, living, k) -> {
            if (living == null) {
                return 0.0f;
            }
            return StakeCrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / (float)StakeCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyPullingName), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == stack && !StakeCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyChargedName), (stack, clientLevel, living, k) -> living != null && StakeCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
    }

    private static void makeGreatCrossbow(Item item, String propertyName, String propertyPullingName, String propertyChargedName, String propertyFireworkName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (stack, clientLevel, living, k) -> {
            if (living == null) {
                return 0.0f;
            }
            return GreatCrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / (float)GreatCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyPullingName), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == stack && !GreatCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyChargedName), (stack, clientLevel, living, k) -> living != null && GreatCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyFireworkName), (stack, clientLevel, living, k) -> living != null && GreatCrossbowItem.m_40932_((ItemStack)stack) && GreatCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }

    private static void makeRoyalCrossbow(Item item, String propertyName, String propertyPullingName, String propertyChargedName, String propertyFireworkName) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyName), (stack, clientLevel, living, k) -> {
            if (living == null) {
                return 0.0f;
            }
            return RoyalCrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / (float)RoyalCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyPullingName), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == stack && !RoyalCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyChargedName), (stack, clientLevel, living, k) -> living != null && RoyalCrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation(propertyFireworkName), (stack, clientLevel, living, k) -> living != null && RoyalCrossbowItem.m_40932_((ItemStack)stack) && RoyalCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }

    private static enum WeaponType {
        KATANA,
        BOOMERANG;

    }
}

