/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.util;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.capability.aberration.AberrationProvider;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.capability.animation.AnimationProvider;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.packets.AberrationPacket;
import net.jaams.jaams_weaponry.packets.AmountPacket;
import net.jaams.jaams_weaponry.packets.AnimationPacket;
import net.jaams.jaams_weaponry.particles.BigWaveParticleData;
import net.jaams.jaams_weaponry.particles.CustomBuffParticleData;
import net.jaams.jaams_weaponry.particles.CustomDebuffParticleData;
import net.jaams.jaams_weaponry.particles.CustomExplosionParticleData;
import net.jaams.jaams_weaponry.particles.CustomFlashParticleData;
import net.jaams.jaams_weaponry.particles.CustomHitParticleData;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.particles.CustomVerticalSweepParticleData;
import net.jaams.jaams_weaponry.particles.MiniSweepParticleData;
import net.jaams.jaams_weaponry.particles.SmallWaveParticleData;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModUtils {
    public static final Logger LOGGER = LogManager.getLogger();

    public static boolean isEntityArmed(LivingEntity entity) {
        return ModUtils.isItemWeapon(entity.m_21205_()) || ModUtils.isItemWeapon(entity.m_21206_());
    }

    public static boolean isSneaking(LivingEntity sourceentity) {
        if (sourceentity instanceof Player) {
            return sourceentity.m_6144_();
        }
        return sourceentity.m_9236_().f_46441_.m_188501_() < 0.5f;
    }

    public static boolean isMobAggressive(LivingEntity entity, Player player) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.m_5448_() == player;
        }
        return false;
    }

    public static boolean isItemWeapon(ItemStack itemStack) {
        return itemStack.m_41720_().m_7167_(EquipmentSlot.MAINHAND).containsKey((Object)Attributes.f_22281_);
    }

    public static boolean hasRestrictedEffect(LivingEntity entity) {
        return entity.m_21023_((MobEffect)JaamsWeaponryModMobEffects.KNOCKED_UP.get()) || entity.m_21023_((MobEffect)JaamsWeaponryModMobEffects.INCAPABLE.get());
    }

    public static boolean isProjectileBreakableBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block == Blocks.f_152588_ || block == Blocks.f_50616_;
    }

    public static void handleItemBreak(ItemStack itemStack, LivingEntity entity, float breakChance, int particleCount, String soundEvent) {
        Level level;
        if (entity == null || itemStack == null || entity.m_9236_().m_5776_() || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.f_46441_.m_188501_() < breakChance && itemStack.m_41613_() > 0) {
            ItemStack particleStack = itemStack.m_41777_();
            boolean isMainHand = ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)entity.m_21205_());
            entity.m_21011_(isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, true);
            Vec3 lookVec = entity.m_20154_().m_82541_();
            Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
            float offset = isMainHand ? 0.15f : -0.15f;
            double startX = entity.m_20185_() + rightVec.f_82479_ * (double)offset;
            double startY = entity.m_20188_();
            double startZ = entity.m_20189_() + rightVec.f_82481_ * (double)offset;
            Vec3 startPos = new Vec3(startX, startY, startZ);
            float particleDistance = 0.5f;
            Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
            ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
            BlockHitResult blockHit = entity.m_9236_().m_45547_(clipContext);
            EntityHitResult entityHit = ModUtils.getEntityHitResult(serverLevel, entity, startPos, endPos);
            double adjustedDistance = particleDistance;
            if (blockHit.m_6662_() != HitResult.Type.MISS) {
                adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
            }
            if (entityHit != null) {
                adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
            }
            adjustedDistance = Math.max(adjustedDistance - (double)0.1f, (double)0.1f);
            double particleX = startX + lookVec.f_82479_ * adjustedDistance;
            double particleY = startY + lookVec.f_82480_ * adjustedDistance;
            double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, particleStack);
            serverLevel.m_8767_((ParticleOptions)particle, particleX, particleY, particleZ, particleCount, 0.1, 0.1, 0.1, 0.05);
            SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEvent));
            if (sound != null) {
                serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            itemStack.m_41774_(1);
        }
    }

    public static void spawnCustomParticlesInFront(LivingEntity entity, ItemStack itemStack, ParticleOptions particleType, float r, float g, float b, float particleSize, float particleDistance, int particleCount, boolean useHandOffset) {
        Level level;
        if (entity == null || itemStack == null || entity.m_9236_().m_5776_() || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lookVec = entity.m_20154_().m_82541_();
        Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double startX = entity.m_20185_();
        double startY = entity.m_20188_();
        double startZ = entity.m_20189_();
        if (useHandOffset) {
            boolean isMainHand = ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)entity.m_21205_());
            float offset = isMainHand ? 0.15f : -0.15f;
            startX += rightVec.f_82479_ * (double)offset;
            startZ += rightVec.f_82481_ * (double)offset;
        }
        Vec3 startPos = new Vec3(startX, startY, startZ);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(clipContext);
        EntityHitResult entityHit = ModUtils.getEntityHitResult(serverLevel, entity, startPos, endPos);
        double adjustedDistance = particleDistance;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
        }
        if (entityHit != null) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
        }
        adjustedDistance = Math.max(adjustedDistance - (double)0.1f, (double)0.1f);
        double particleX = startX + lookVec.f_82479_ * adjustedDistance;
        double particleY = startY + lookVec.f_82480_ * adjustedDistance;
        double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
        ParticleOptions finalParticle = particleType;
        if (particleType instanceof CustomHitParticleData) {
            finalParticle = new CustomHitParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomVerticalSweepParticleData) {
            finalParticle = new CustomVerticalSweepParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomFlashParticleData) {
            finalParticle = new CustomFlashParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomExplosionParticleData) {
            finalParticle = new CustomExplosionParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomSweepParticleData) {
            finalParticle = new CustomSweepParticleData(r, g, b, particleSize);
        } else if (particleType instanceof MiniSweepParticleData) {
            finalParticle = new MiniSweepParticleData(r, g, b, particleSize);
        } else if (particleType instanceof BigWaveParticleData) {
            finalParticle = new BigWaveParticleData(r, g, b, particleSize);
        } else if (particleType instanceof SmallWaveParticleData) {
            finalParticle = new SmallWaveParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomBuffParticleData) {
            finalParticle = new CustomBuffParticleData(r, g, b, particleSize);
        } else if (particleType instanceof CustomDebuffParticleData) {
            finalParticle = new CustomDebuffParticleData(r, g, b, particleSize);
        }
        serverLevel.m_8767_(finalParticle, particleX, particleY, particleZ, particleCount, 0.0, 0.0, 0.0, 0.0);
    }

    public static void spawnItemParticlesInFront(LivingEntity entity, ItemStack itemStack, int particleCount, float particleDistance, boolean useHandOffset) {
        Level level;
        if (entity == null || itemStack == null || entity.m_9236_().m_5776_() || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 lookVec = entity.m_20154_().m_82541_();
        Vec3 rightVec = lookVec.m_82537_(new Vec3(0.0, 1.0, 0.0)).m_82541_();
        double startX = entity.m_20185_();
        double startY = entity.m_20188_();
        double startZ = entity.m_20189_();
        if (useHandOffset) {
            boolean isMainHand = ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)entity.m_21205_());
            float offset = isMainHand ? 0.15f : -0.15f;
            startX += rightVec.f_82479_ * (double)offset;
            startZ += rightVec.f_82481_ * (double)offset;
        }
        Vec3 startPos = new Vec3(startX, startY, startZ);
        Vec3 endPos = startPos.m_82549_(lookVec.m_82490_((double)particleDistance));
        ClipContext clipContext = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity);
        BlockHitResult blockHit = entity.m_9236_().m_45547_(clipContext);
        EntityHitResult entityHit = ModUtils.getEntityHitResult(serverLevel, entity, startPos, endPos);
        double adjustedDistance = particleDistance;
        if (blockHit.m_6662_() != HitResult.Type.MISS) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(blockHit.m_82450_()));
        }
        if (entityHit != null) {
            adjustedDistance = Math.min(adjustedDistance, startPos.m_82554_(entityHit.m_82450_()));
        }
        adjustedDistance = Math.max(adjustedDistance - (double)0.1f, (double)0.1f);
        double particleX = startX + lookVec.f_82479_ * adjustedDistance;
        double particleY = startY + lookVec.f_82480_ * adjustedDistance;
        double particleZ = startZ + lookVec.f_82481_ * adjustedDistance;
        ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, itemStack.m_41777_());
        serverLevel.m_8767_((ParticleOptions)particle, particleX, particleY, particleZ, particleCount, 0.1, 0.1, 0.1, 0.05);
    }

    public static EntityHitResult getEntityHitResult(ServerLevel level, LivingEntity shooter, Vec3 startPos, Vec3 endPos) {
        AABB aabb = new AABB(startPos, endPos).m_82400_(1.0);
        for (Entity entity : level.m_6249_((Entity)shooter, aabb, e -> e instanceof LivingEntity && e.m_6087_())) {
            AABB entityBox = entity.m_20191_().m_82400_(0.3);
            Optional hit = entityBox.m_82371_(startPos, endPos);
            if (!hit.isPresent()) continue;
            return new EntityHitResult(entity, (Vec3)hit.get());
        }
        return null;
    }

    public static boolean isInFrontArea(LivingEntity entity, Entity source) {
        Direction entityFront = entity.m_6350_();
        Direction attackerFacing = Direction.m_122366_((double)(source.m_20185_() - entity.m_20185_()), (double)0.0, (double)(source.m_20189_() - entity.m_20189_()));
        Direction leftSide = entityFront.m_122428_();
        Direction rightSide = entityFront.m_122427_();
        return attackerFacing == entityFront || attackerFacing == leftSide || attackerFacing == rightSide;
    }

    public static void playSound(Entity entity, String soundEvent) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = entity.m_20183_();
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEvent));
        if (sound != null) {
            level2.m_5594_(null, pos, sound, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void playSound(Entity entity, String soundEvent, SoundSource source) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = entity.m_20183_();
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEvent));
        if (sound != null) {
            level2.m_5594_(null, pos, sound, source, 1.0f, 1.0f);
        }
    }

    public static void playSound(Entity entity, String soundEvent, SoundSource source, float volume, float pitch) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = entity.m_20183_();
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEvent));
        if (sound != null) {
            level2.m_5594_(null, pos, sound, source, volume, pitch);
        }
    }

    public static void playClientSound(Entity entity, String soundEvent) {
        Level level = entity.m_9236_();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel level2 = (ClientLevel)level;
        BlockPos pos = entity.m_20183_();
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEvent));
        if (sound != null) {
            level2.m_245747_(pos, sound, SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }

    public static void triggerExplosion(LivingEntity entity) {
        entity.m_9236_().m_254849_((Entity)entity, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ((Double)JaamsWeaponryCommonConfiguration.DYNAMITEPOWER.get()).floatValue(), Level.ExplosionInteraction.NONE);
    }

    public static ItemStack getItemInMainHand(LivingEntity entity, Item item) {
        ItemStack mainHand = entity.m_21205_();
        return mainHand.m_150930_(item) ? mainHand : ItemStack.f_41583_;
    }

    public static ItemStack getItemInEitherHand(LivingEntity entity, Item item) {
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        return mainHand.m_150930_(item) ? mainHand : (offHand.m_150930_(item) ? offHand : ItemStack.f_41583_);
    }

    public static ItemStack getItemInEitherHand(LivingEntity entity, Predicate<ItemStack> predicate) {
        ItemStack mainHand = entity.m_21205_();
        if (!mainHand.m_41619_() && predicate.test(mainHand)) {
            return mainHand;
        }
        ItemStack offHand = entity.m_21206_();
        if (!offHand.m_41619_() && predicate.test(offHand)) {
            return offHand;
        }
        return ItemStack.f_41583_;
    }

    public static Vec3 getDirectionToTarget(LivingEntity entity, LivingEntity target) {
        return new Vec3(target.m_20185_() - entity.m_20185_(), target.m_20188_() - entity.m_20188_(), target.m_20189_() - entity.m_20189_()).m_82541_();
    }

    public static boolean canThrowAtTarget(LivingEntity entity, LivingEntity target, double minDistance, double maxDistance) {
        double distance = target.m_20270_((Entity)entity);
        Vec3 direction = ModUtils.getDirectionToTarget(entity, target);
        Vec3 entityLook = entity.m_20154_().m_82541_();
        double angle = direction.m_82526_(entityLook);
        return distance <= maxDistance && distance >= minDistance && angle > 0.5;
    }

    public static boolean hasEpicFightAttribute(LivingEntity entity) {
        if (entity == null) {
            return false;
        }
        if (entity.m_6095_() == EntityType.f_20532_) {
            return false;
        }
        ResourceLocation staminaAttributeId = new ResourceLocation("epicfight", "weight");
        Attribute staminaAttribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(staminaAttributeId);
        if (staminaAttribute == null) {
            return false;
        }
        return entity.m_21204_().m_22171_(staminaAttribute);
    }

    public static boolean isItemInCuriosSlot(Entity entity, String itemId, String slotIdentifier) {
        if (entity == null || itemId == null || slotIdentifier == null) {
            return false;
        }
        CompoundTag entityData = new CompoundTag();
        entity.m_20240_(entityData);
        CompoundTag forgeCaps = entityData.m_128469_("ForgeCaps");
        if (!forgeCaps.m_128441_("curios:inventory")) {
            return false;
        }
        CompoundTag curiosInventory = forgeCaps.m_128469_("curios:inventory");
        ListTag curiosList = curiosInventory.m_128437_("Curios", 10);
        for (int i = 0; i < curiosList.size(); ++i) {
            CompoundTag curioSlot = curiosList.m_128728_(i);
            String identifier = curioSlot.m_128461_("Identifier");
            if (!slotIdentifier.equals(identifier)) continue;
            CompoundTag stacksHandler = curioSlot.m_128469_("StacksHandler");
            CompoundTag stacks = stacksHandler.m_128469_("Stacks");
            ListTag items = stacks.m_128437_("Items", 10);
            for (int j = 0; j < items.size(); ++j) {
                CompoundTag item = items.m_128728_(j);
                String id = item.m_128461_("id");
                if (!itemId.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isEntityInBattleMode(Entity entity) {
        if (entity == null) {
            return false;
        }
        CompoundTag entityData = new CompoundTag();
        entity.m_20240_(entityData);
        CompoundTag forgeCaps = entityData.m_128469_("ForgeCaps");
        if (forgeCaps.m_128441_("epicfight:skill_cap")) {
            CompoundTag skillCap = forgeCaps.m_128469_("epicfight:skill_cap");
            String playerMode = skillCap.m_128461_("playerMode");
            return "EPICFIGHT".equals(playerMode) || "BATTLE".equals(playerMode);
        }
        return false;
    }

    public static boolean isAlliedEntity(Player player, Entity entity) {
        Player otherPlayer;
        TamableAnimal tamable;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && tamable.m_269323_() == player) {
            return true;
        }
        if (entity instanceof Player && !player.m_7099_(otherPlayer = (Player)entity)) {
            return true;
        }
        return entity == player.m_20202_();
    }

    public static String getPlayerAnimation(Player player) {
        return player.getCapability(AnimationProvider.ANIMATION).map(animationCap -> animationCap.getAnimation() != null ? animationCap.getAnimation() : "").orElse("");
    }

    public static void applyShakeEffect(Entity entity, double shakeAmount, int shakeResetDelay) {
        ServerPlayer player;
        block3: {
            block2: {
                if (entity == null || !(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        player.getCapability(AberrationProvider.ABERRATION).ifPresent(aberration -> {
            aberration.setEffectType(ModEnums.AberrationType.SHAKE);
            aberration.setIntensity(shakeAmount);
            aberration.setDuration(shakeResetDelay);
            JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AberrationPacket(player.m_19879_(), aberration.getEffectType(), aberration.getIntensity(), aberration.getDuration()));
        });
    }

    public static void applyAnimation(Entity entity, String animation, int duration) {
        ServerPlayer player;
        block3: {
            block2: {
                if (entity == null || !(entity instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)entity;
                if (!player.m_9236_().f_46443_) break block3;
            }
            return;
        }
        player.getCapability(AnimationProvider.ANIMATION).ifPresent(animationCap -> {
            animationCap.setAnimation(animation);
            animationCap.setDuration(duration);
            JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new AnimationPacket(player.m_19879_(), animationCap.getAnimation(), animationCap.getDuration()));
        });
    }

    public static void applyBonusDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_()) {
            return;
        }
        try {
            DamageSource damageSource = attacker.m_269291_().m_269264_();
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying bonus damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static void applyBackstabDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_() || attacker.m_9236_() == null) {
            return;
        }
        try {
            RegistryAccess registryAccess = attacker.m_9236_().m_9598_();
            ResourceKey damageKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:backstab"));
            DamageSource damageSource = attacker instanceof Player ? new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey), (Entity)((Player)attacker)) : new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey));
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying backstab damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static void applyBreachDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_() || attacker.m_9236_() == null) {
            return;
        }
        try {
            RegistryAccess registryAccess = attacker.m_9236_().m_9598_();
            ResourceKey damageKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:breach"));
            DamageSource damageSource = attacker instanceof Player ? new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey), (Entity)((Player)attacker)) : new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey));
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying breach damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static void applySmashDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_() || attacker.m_9236_() == null) {
            return;
        }
        try {
            RegistryAccess registryAccess = attacker.m_9236_().m_9598_();
            ResourceKey damageKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:smash"));
            DamageSource damageSource = attacker instanceof Player ? new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey), (Entity)((Player)attacker)) : new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey));
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying smash damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static void applyPiercingDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_() || attacker.m_9236_() == null) {
            return;
        }
        try {
            RegistryAccess registryAccess = attacker.m_9236_().m_9598_();
            ResourceKey damageKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:piercing"));
            DamageSource damageSource = attacker instanceof Player ? new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey), (Entity)((Player)attacker)) : new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(damageKey));
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying piercing damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static void applyMagicDamage(LivingEntity attacker, LivingEntity target, ItemStack itemStack, float damageBonus) {
        if (attacker == null || target == null || itemStack == null || !target.m_6084_() || attacker.m_9236_() == null) {
            return;
        }
        try {
            RegistryAccess registryAccess = attacker.m_9236_().m_9598_();
            DamageSource damageSource = attacker instanceof Player ? new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_), (Entity)((Player)attacker)) : new DamageSource((Holder)registryAccess.m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268515_));
            attacker.getCapability(AmountProvider.AMOUNT).ifPresent(capability -> {
                float baseDamage = capability.getDamage();
                float totalDamage = baseDamage + damageBonus;
                if (totalDamage > 0.0f) {
                    target.m_6469_(damageSource, totalDamage);
                }
            });
        }
        catch (Exception e) {
            JaamsWeaponryMod.LOGGER.error("Error applying magic damage to {}: {}", (Object)target, (Object)e.getMessage());
        }
    }

    public static float calculateDistanceBonus(LivingEntity sourceEntity, LivingEntity targetEntity, boolean isCritical, float maxBonusBlocks, float minDistanceBlocks, float distanceBonusPerBlock, float criticalBonusMultiplier) {
        double heightDifference;
        double dz;
        double dx = sourceEntity.m_20185_() - targetEntity.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = sourceEntity.m_20189_() - targetEntity.m_20189_()) * dz);
        float totalBlocks = (float)Math.min(Math.max(horizontalDistance, heightDifference = Math.abs(sourceEntity.m_20188_() - targetEntity.m_20188_())), (double)maxBonusBlocks);
        if (totalBlocks < minDistanceBlocks) {
            return 0.0f;
        }
        return totalBlocks * distanceBonusPerBlock;
    }

    public static void cancelDamage(LivingEntity target, LivingEntity source) {
        if (source instanceof Player) {
            Player player = (Player)source;
            if (!target.m_21224_()) {
                player.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> {
                    float healAmount = amount.getDamage();
                    if (healAmount > 0.0f && Float.isFinite(healAmount)) {
                        float currentHealth = target.m_21223_();
                        float maxHealth = target.m_21233_();
                        float newHealth = Math.min(currentHealth + healAmount, maxHealth);
                        target.m_21153_(newHealth);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            JaamsWeaponryMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new AmountPacket(player.m_19879_(), amount.getDamage()));
                        }
                    }
                });
            }
        }
    }

    public static boolean isBlocked(LivingEntity defender, Entity attacker) {
        if (defender.m_21254_() && attacker != null) {
            Vec3 attackerPos = attacker.m_20182_();
            Vec3 defenderLook = defender.m_20154_();
            Vec3 directionToAttacker = attackerPos.m_82546_(defender.m_20182_()).m_82541_();
            Vec3 horizontalDirection = new Vec3(directionToAttacker.f_82479_, 0.0, directionToAttacker.f_82481_).m_82541_();
            return horizontalDirection.m_82526_(defenderLook) < 0.0;
        }
        return false;
    }

    public static boolean isProjectileCritical(Player player, float power) {
        boolean attackPowerFull = power >= 1.0f;
        boolean inAir = !player.m_20096_();
        boolean hasFallen = player.f_19789_ > 0.0f;
        boolean notClimbing = !player.m_6147_();
        boolean notWet = !player.m_20069_();
        boolean notBlind = !player.m_21023_(MobEffects.f_19610_);
        boolean notRiding = !player.m_20159_();
        boolean notSprinting = !player.m_20142_();
        return attackPowerFull && inAir && hasFallen && notClimbing && notWet && notBlind && notRiding && notSprinting;
    }

    public static boolean isCritical(Player player, Entity target, float chargeStrength) {
        boolean attackPowerFull = chargeStrength > 0.9f;
        boolean hasFallen = player.f_19789_ > 0.0f;
        boolean inAir = !player.m_20096_();
        boolean notClimbing = !player.m_6147_();
        boolean notWet = !player.m_20069_();
        boolean notBlind = !player.m_21023_(MobEffects.f_19610_);
        boolean notRiding = !player.m_20159_();
        boolean notSprinting = !player.m_20142_();
        boolean targetValid = target instanceof LivingEntity;
        return attackPowerFull && hasFallen && inAir && notClimbing && notWet && notBlind && notRiding && notSprinting && targetValid;
    }

    public static boolean isFlyingEntity(LivingEntity entity, float flyingMinDistance) {
        int blockY;
        if (entity.m_20096_()) {
            return false;
        }
        Level level = entity.m_9236_();
        Vec3 position = entity.m_20182_();
        double x = position.f_82479_;
        double y = position.f_82480_;
        double z = position.f_82481_;
        for (int i = blockY = (int)Math.floor(y); i > level.m_141937_(); --i) {
            BlockState blockState = level.m_8055_(new BlockPos((int)x, i, (int)z));
            if (blockState.m_60795_()) continue;
            double distanceToBlock = y - (double)(i + 1);
            return distanceToBlock >= (double)flyingMinDistance;
        }
        return true;
    }

    public static boolean isLookingAtEntity(LivingEntity viewer, Entity target, double maxAngle) {
        Vec3 directionToTarget;
        Vec3 viewerLook = viewer.m_20154_();
        return viewerLook.m_82526_(directionToTarget = target.m_20182_().m_82546_(viewer.m_20182_()).m_82541_()) > Math.cos(Math.toRadians(maxAngle));
    }

    public static boolean isHeadshot(Entity attacker, Entity target) {
        double headHeight = target.m_20191_().f_82292_ - target.m_20191_().m_82376_() * 0.25;
        return attacker.m_146892_().f_82480_ > headHeight;
    }

    public static boolean isBodyshot(Entity attacker, Entity target) {
        double minBodyHeight = target.m_20191_().f_82289_ + target.m_20191_().m_82376_() * 0.25;
        double maxBodyHeight = target.m_20191_().f_82292_ - target.m_20191_().m_82376_() * 0.25;
        double attackerEyeHeight = attacker.m_146892_().f_82480_;
        return attackerEyeHeight >= minBodyHeight && attackerEyeHeight <= maxBodyHeight;
    }

    public static void applyRecoil(LivingEntity entity, float recoilDistance, float crouchRecoilReduction, float verticalRecoilMultiplier) {
        float f;
        Player player;
        Player player2;
        if (entity == null || recoilDistance <= 0.0f) {
            return;
        }
        double recoilMultiplier = recoilDistance;
        if (entity instanceof Player && (player2 = (Player)entity).m_6047_() && !player2.m_7500_()) {
            recoilMultiplier *= (double)crouchRecoilReduction;
            if (!player2.m_7500_()) {
                player2.m_36324_().m_38703_(0.2f);
            }
        } else if (entity instanceof Player && !(player = (Player)entity).m_7500_()) {
            player.m_36324_().m_38703_(0.5f);
        }
        double knockbackResistance = Math.max(0.0, Math.min(1.0, entity.m_21133_(Attributes.f_22278_)));
        double knockbackReduction = 1.0 - Math.pow(1.0 - knockbackResistance, 4.0);
        recoilMultiplier *= 1.0 - knockbackReduction;
        double movementSpeed = entity.m_21133_(Attributes.f_22279_);
        double baseMovementSpeed = 0.1;
        double movementSpeedMultiplier = Math.max(0.1, movementSpeed / baseMovementSpeed);
        double horizontalRecoil = 1.2 * (recoilMultiplier *= movementSpeedMultiplier);
        double verticalRecoil = 1.2 * (double)verticalRecoilMultiplier * recoilMultiplier;
        horizontalRecoil = Math.max(0.0, horizontalRecoil);
        verticalRecoil = Math.max(0.0, verticalRecoil);
        if (horizontalRecoil < 0.01 && verticalRecoil < 0.01) {
            return;
        }
        float yaw = entity.m_6080_() * ((float)Math.PI / 180);
        if (entity instanceof Player) {
            Player player3 = (Player)entity;
            f = player3.m_146909_() * ((float)Math.PI / 180);
        } else {
            f = 0.0f;
        }
        float pitch = f;
        double motionX = Math.sin(yaw) * horizontalRecoil * Math.cos(pitch);
        double motionZ = -Math.cos(yaw) * horizontalRecoil * Math.cos(pitch);
        double motionY = 0.0;
        float MIN_PITCH_FOR_VERTICAL_DEGREES = 45.0f;
        float minPitchForVertical = (float)Math.toRadians(45.0);
        double horizontalScale = 1.0;
        if (pitch > minPitchForVertical) {
            float pitchFactor = (pitch - minPitchForVertical) / (1.5707964f - minPitchForVertical);
            pitchFactor = Math.min(1.0f, pitchFactor);
            double verticalScale = Math.cos((double)pitchFactor * Math.PI / 2.0);
            motionY = verticalRecoil * (1.0 - verticalScale);
            horizontalScale = Math.max(0.5, 1.0 - (double)pitchFactor * 0.5);
            motionX *= horizontalScale;
            motionZ *= horizontalScale;
        }
        motionX = Mth.m_14008_((double)motionX, (double)-1.5, (double)1.5);
        motionY = Mth.m_14008_((double)motionY, (double)(-1.5 * (double)verticalRecoilMultiplier), (double)(1.5 * (double)verticalRecoilMultiplier));
        motionZ = Mth.m_14008_((double)motionZ, (double)-1.5, (double)1.5);
        entity.m_20256_(entity.m_20184_().m_82520_(motionX, motionY, motionZ));
        entity.f_19864_ = true;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity));
        } else if (!entity.m_9236_().f_46443_) {
            entity.m_9236_().m_45933_(null, entity.m_20191_().m_82400_(10.0)).stream().filter(e -> e instanceof ServerPlayer).forEach(e -> ((ServerPlayer)e).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)entity)));
        }
    }

    public static boolean matchesList(Set<String> set, ResourceLocation itemKey, Item item, boolean isWhitelist) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (String entry : set) {
            String namespace;
            String[] parts;
            if ((entry = entry.trim()).isEmpty()) continue;
            if (entry.equals("all")) {
                if (!ForgeRegistries.ITEMS.containsKey(itemKey)) continue;
                return true;
            }
            if (entry.startsWith("#")) {
                try {
                    String tagName = entry.substring(1);
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(tagName));
                    if (!item.m_204114_().m_203656_(tag)) continue;
                    return true;
                }
                catch (ResourceLocationException e) {
                    LOGGER.warn("Invalid tag entry in list (ignoring): '{}'", (Object)entry);
                    continue;
                }
            }
            if (entry.equals("bows:*")) {
                if (!(item instanceof BowItem)) continue;
                return true;
            }
            if (entry.equals("crossbows:*")) {
                if (!(item instanceof CrossbowItem)) continue;
                return true;
            }
            if (entry.equals("swords:*")) {
                if (!(item instanceof SwordItem)) continue;
                return true;
            }
            if (entry.equals("pickaxes:*")) {
                if (!(item instanceof PickaxeItem)) continue;
                return true;
            }
            if (entry.equals("axes:*")) {
                if (!(item instanceof AxeItem)) continue;
                return true;
            }
            if (entry.equals("blocks:*")) {
                if (!(item instanceof BlockItem)) continue;
                return true;
            }
            if (entry.equals("edibles:*")) {
                if (item.m_41473_() == null) continue;
                return true;
            }
            if (entry.equals("shovels:*")) {
                if (!(item instanceof ShovelItem)) continue;
                return true;
            }
            if (entry.equals("hoes:*")) {
                if (!(item instanceof HoeItem)) continue;
                return true;
            }
            if (entry.equals("armor:*")) {
                if (!(item instanceof ArmorItem)) continue;
                return true;
            }
            if (entry.contains(":*")) {
                parts = entry.split(":");
                if (parts.length != 2 || !parts[1].equals("*")) continue;
                namespace = parts[0];
                if (!itemKey.m_135827_().equals(namespace)) continue;
                return true;
            }
            if (entry.contains("*")) {
                parts = entry.split(":");
                if (parts.length == 2) {
                    namespace = parts[0];
                    String pattern = parts[1].replace("*", "");
                    if (!itemKey.m_135827_().equals(namespace) || !itemKey.m_135815_().contains(pattern)) continue;
                    return true;
                }
                if (parts.length == 1) {
                    String pattern = parts[0].replace("*", "");
                    if (!itemKey.m_135815_().contains(pattern)) continue;
                    return true;
                }
                LOGGER.warn("Invalid wildcard pattern (ignoring): '{}'. Expected format: 'namespace:pattern' or 'pattern'", (Object)entry);
                continue;
            }
            try {
                ResourceLocation resourceLocation = new ResourceLocation(entry);
                if (!ForgeRegistries.ITEMS.containsKey(resourceLocation) || !itemKey.equals((Object)resourceLocation)) continue;
                return true;
            }
            catch (ResourceLocationException e) {
                LOGGER.warn("Invalid entry in list (ignoring): '{}'", (Object)entry);
            }
        }
        return false;
    }
}

