/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.List;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.handler.mechanics.DisablerHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SweepAttackHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class BattleAxeItem
extends AxeItem {
    public static final double SWEEP_RANGE = 1.0;
    public static final float BASE_DAMAGE_PERCENT = 0.5f;
    public static final int WEAPON_DAMAGE_PENALTY = 1;
    public static final boolean DAMAGE_BY_ENEMY_COUNT = true;
    public static final int NON_SHIELD_DISABLE_TICKS = 60;
    public static final float BASE_CRITICAL_CHANCE = 0.15f;
    public static final float BASE_FULLY_CHARGED_CHANCE = 0.05f;
    public static final float CHANCE_INCREMENT = 0.05f;
    public static final int INCAPABLE_CRITICAL_DURATION = 140;
    public static final int INCAPABLE_FULLY_CHARGED_DURATION = 100;
    public static final int INCAPABLE_EFFECT_LEVEL = 0;

    public BattleAxeItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, (float)attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.AXE_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_ || enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44982_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isCritical;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean isFullyCharged = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf((float)sourceentity.m_21133_(Attributes.f_22281_))).floatValue();
        this.applyAttackEffects(itemstack, entity, sourceentity, baseDamage, isCritical, isFullyCharged);
        return retval;
    }

    public void applyAttackEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical, boolean isFullyCharged) {
        float entityHealth = entity.m_21223_();
        boolean isEnemyUsingItem = !entity.m_21205_().m_41619_() || !entity.m_21206_().m_41619_();
        float criticalChance = 0.15f + (isEnemyUsingItem ? 0.05f : 0.0f);
        float fullyChargedChance = 0.05f + (isEnemyUsingItem ? 0.05f : 0.0f);
        if (isCritical && entityHealth > baseDamage && entity.m_9236_().f_46441_.m_188501_() < criticalChance) {
            entity.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.INCAPABLE.get(), 140, 0));
        }
        if (isFullyCharged) {
            if (entityHealth > baseDamage && entity.m_9236_().f_46441_.m_188501_() < fullyChargedChance) {
                entity.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.INCAPABLE.get(), 100, 0));
            }
            this.applyItemDisable(entity);
            if (sourceentity instanceof Player) {
                Player player = (Player)sourceentity;
                this.performSweepAttackWithDisable(itemstack, entity, player);
            }
        }
    }

    public void performSweepAttackWithDisable(ItemStack itemstack, LivingEntity entity, Player player) {
        SweepAttackHandler.performSweepAttack(itemstack, entity, (LivingEntity)player, 1.0f, 0.5f, 1, true, SoundEvents.f_12317_, (ParticleOptions)ParticleTypes.f_123766_, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        Level level = entity.m_9236_();
        AABB sweepArea = new AABB(entity.m_20182_().m_82520_(-1.0, -1.0, -1.0), entity.m_20182_().m_82520_(1.0, 1.0, 1.0));
        List nearbyEnemies = level.m_6443_(LivingEntity.class, sweepArea, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        for (LivingEntity nearby2 : nearbyEnemies) {
            this.applyItemDisable(nearby2);
        }
    }

    public void applyItemDisable(LivingEntity entity) {
        if (entity.m_6117_()) {
            ItemStack activeItem = entity.m_21211_();
            if (!activeItem.m_41619_() && !(activeItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 60);
            }
        } else {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (!mainHandItem.m_41619_() && !(mainHandItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 60);
            } else if (!offHandItem.m_41619_() && !(offHandItem.m_41720_() instanceof ShieldItem)) {
                DisablerHandler.disableActiveItem(entity, 60);
            }
        }
    }
}

