/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.entity.BroomProjectileEntity;
import net.jaams.jaams_weaponry.handler.events.AdvancementsHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BroomBaseItem
extends SwordItem {
    public static final float ARTHROPOD_BONUS_DAMAGE = 6.0f;
    public static final float EFFECT_CLEANSE_CHANCE = 0.1f;
    public static final float EXTINGUISH_FIRE_CHANCE = 0.3f;
    public static final float KNOCKBACK_FORCE = 0.3f;
    public static final int MAX_DRAW_DURATION = 20;
    public static final float MIN_PROJECTILE_SPEED = 0.3f;
    public static final float MAX_PROJECTILE_SPEED = 1.8f;

    public BroomBaseItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44955_ || enchantment == Enchantments.f_44959_) {
            return true;
        }
        if (enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44977_ || enchantment == Enchantments.f_44981_ || enchantment == Enchantments.f_44982_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean hasBaneOfArthropods;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        boolean hasFireAspect = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)itemstack) > 0;
        boolean bl = hasBaneOfArthropods = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)itemstack) > 0;
        if (isFullyCharged) {
            this.cleanseEffects(entity, level, hasBaneOfArthropods);
            this.extinguishFire(entity, level, hasFireAspect);
            entity.m_147240_((double)0.3f, sourceentity.m_20185_() - entity.m_20185_(), sourceentity.m_20189_() - entity.m_20189_());
        }
        if (isCritical) {
            entity.m_147240_(0.5, sourceentity.m_20185_() - entity.m_20185_(), sourceentity.m_20189_() - entity.m_20189_());
        }
        if (entity.m_6336_() == MobType.f_21642_) {
            ModUtils.applyBonusDamage(sourceentity, entity, itemstack, 6.0f);
        }
        if (!level.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.spawnItemParticles(serverLevel, itemstack, entity, level.f_46441_, 5);
        }
        ModUtils.playSound((Entity)entity, "jaams_weaponry:broom_hit");
        return retval;
    }

    public void cleanseEffects(LivingEntity entity, Level level, boolean hasBaneOfArthropods) {
        LivingEntity livingEntity;
        float cleanseChance = 0.1f;
        LivingEntity livingEntity2 = entity.m_21188_();
        if (livingEntity2 instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity2;
            boolean hasBroomsAndPotions = AdvancementsHandler.hasAdvancement(player, "brooms_and_potions");
            float f = cleanseChance = hasBroomsAndPotions ? 0.2f : 0.1f;
        }
        if (level.m_213780_().m_188501_() >= cleanseChance || entity.m_21220_().isEmpty()) {
            return;
        }
        int effectsRemoved = entity.m_21220_().size();
        MobEffectInstance slowness = null;
        if (hasBaneOfArthropods && entity.m_6336_() == MobType.f_21642_) {
            slowness = entity.m_21124_(MobEffects.f_19597_);
        }
        entity.m_21219_();
        if (slowness != null) {
            entity.m_7292_(new MobEffectInstance(slowness));
        }
        if ((livingEntity = entity.m_21188_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (effectsRemoved >= 6) {
                AdvancementsHandler.grantAdvancement(player, "brooms_and_potions");
            }
        }
        ModUtils.playSound((Entity)entity, "jaams_weaponry:broom_clean");
        if (!level.m_5776_()) {
            this.spawnEffectParticles((ServerLevel)level, entity, (ParticleOptions)ParticleTypes.f_123796_, 5);
        }
    }

    public void extinguishFire(LivingEntity entity, Level level, boolean hasFireAspect) {
        if (!hasFireAspect && entity.m_6060_() && level.m_213780_().m_188501_() < 0.3f) {
            entity.m_20095_();
            ModUtils.playSound((Entity)entity, "block.fire.extinguish");
            if (!level.m_5776_()) {
                this.spawnEffectParticles((ServerLevel)level, entity, (ParticleOptions)ParticleTypes.f_123762_, 5);
            }
        }
    }

    public void spawnItemParticles(ServerLevel serverLevel, ItemStack itemstack, LivingEntity entity, RandomSource random, int particleCount) {
        if (itemstack == null || itemstack.m_41619_()) {
            return;
        }
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = entity.m_20185_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            double yOffset = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (random.m_188500_() - 0.5) * (double)entity.m_20206_() * 0.5;
            double zOffset = entity.m_20189_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, itemstack), xOffset, yOffset, zOffset, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    public void spawnEffectParticles(ServerLevel serverLevel, LivingEntity entity, ParticleOptions particleType, int particleCount) {
        RandomSource random = serverLevel.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double xOffset = entity.m_20185_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            double yOffset = entity.m_20186_() + (double)entity.m_20206_() * 0.5 + (random.m_188500_() - 0.5) * (double)entity.m_20206_() * 0.5;
            double zOffset = entity.m_20189_() + (random.m_188500_() - 0.5) * (double)entity.m_20205_();
            serverLevel.m_8767_(particleType, xOffset, yOffset, zOffset, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemstack) - durationUsed;
            if (remainingDuration >= 5 && !level.f_46443_) {
                float power = BroomBaseItem.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                boolean isCreative = player.m_150110_().f_35937_;
                boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack) > 0;
                int projectileCount = hasMultishot ? 3 : 1;
                float[] shotPitches = BroomBaseItem.generateShotPitches(level.m_213780_(), projectileCount);
                int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemstack);
                for (int i = 0; i < projectileCount; ++i) {
                    BroomProjectileEntity projectile = new BroomProjectileEntity(level, (LivingEntity)player, itemstack.m_41777_());
                    int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                    projectile.setOriginalSlotIndex(slotIndex);
                    if (ModUtils.isProjectileCritical(player, power)) {
                        projectile.setCritical(true);
                    }
                    projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                    if (hasMultishot) {
                        AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                        if (i != 0) {
                            projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                        }
                        float spreadAngle = 10.0f;
                        float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                        Vec3 upVector = player.m_20289_(1.0f);
                        Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                        Vec3 viewVector = player.m_20252_(1.0f);
                        Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                        if (i == 0) {
                            float forwardOffset = 1.0f;
                            Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                            projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                        }
                        projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                    } else {
                        projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                    }
                    projectile.setWeaponItem(itemstack.m_41777_());
                    level.m_7967_((Entity)projectile);
                    SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:broom_throw"));
                    level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                }
                if (!isCreative) {
                    itemstack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 1.5f;
        float scaledPower = power * power;
        return 0.3f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

