/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.handler.events.AdvancementsHandler;
import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SweepAttackHandler;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.particles.CustomVerticalSweepParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class BusterSwordItem
extends SwordItem {
    public static int ARMOR_DAMAGE_AMOUNT = 6;
    public static float ARMOR_DAMAGE_CHANCE = 0.8f;
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 6;
    public static final float HELD_ITEM_DAMAGE_CHANCE = 0.6f;
    public static final float BUSTER_STRIKE_BONUS_MULTIPLIER = 0.7f;
    public static final int BUSTER_STRIKE_DURABILITY_PENALTY = 3;
    public static final float BUSTER_STRIKE_CHANCE = 0.3f;
    public static final float BUSTER_STRIKE_REMOVE_CHANCE = 0.3f;
    private static final String BUSTER_STRIKE_TAG = "BusterSwordStrike";
    public static final double SWEEP_RANGE = 1.0;
    public static final float BASE_DAMAGE_PERCENT = 0.5f;
    public static final int WEAPON_DAMAGE_PENALTY = 1;
    public static final boolean DAMAGE_BY_ENEMY_COUNT = true;
    public static final int DEPLETION_DURATION = 60;
    public static final int DEPLETION_LEVEL = 2;
    public static final boolean ENABLE_DEPLETION = true;
    public static final int PARTICLE_AREA_SIZE = 3;
    public static final int PARTICLES_PER_BLOCK = 3;
    public static final float PARTICLE_OFFSET_SCALE = 0.3f;
    public static final float PARTICLE_SPEED = 0.1f;
    public static final boolean ENABLE_ATTACK_PARTICLES = true;

    public BusterSwordItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isCritical;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean isFullyCharged = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        Level level = entity.m_9236_();
        if (isFullyCharged) {
            this.performChargedAttackEffects(itemstack, entity, sourceentity, level, isCritical);
        }
        return retval;
    }

    public void performChargedAttackEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, Level level, boolean isCritical) {
        ServerPlayer player;
        RandomSource random = level.f_46441_;
        if (random.m_188501_() < ARMOR_DAMAGE_CHANCE) {
            BreakingHandler.damageArmorPieces(entity, ARMOR_DAMAGE_AMOUNT, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
        }
        if (random.m_188501_() < 0.6f) {
            BreakingHandler.damageHeldItem(entity, 6);
        }
        boolean hasBusterStrikeTag = entity.m_19880_().contains(BUSTER_STRIKE_TAG);
        boolean appliedStrike = false;
        float busterStrikeChance = 0.3f;
        if (sourceentity instanceof ServerPlayer) {
            player = (ServerPlayer)sourceentity;
            boolean hasRuderBuster = AdvancementsHandler.hasAdvancement(player, "ruder_buster");
            float f = busterStrikeChance = hasRuderBuster ? 0.6f : 0.3f;
        }
        if (!hasBusterStrikeTag) {
            this.applyBusterStrikeDamage(sourceentity, entity, itemstack, level);
            entity.m_20049_(BUSTER_STRIKE_TAG);
            appliedStrike = true;
        } else if (random.m_188501_() < busterStrikeChance) {
            this.applyBusterStrikeDamage(sourceentity, entity, itemstack, level);
            appliedStrike = true;
        }
        if (appliedStrike && isCritical && random.m_188501_() < 0.3f) {
            entity.m_20137_(BUSTER_STRIKE_TAG);
        }
        if (sourceentity instanceof Player) {
            player = (Player)sourceentity;
            this.performSweepAttack(itemstack, entity, (Player)player);
        }
    }

    public void applyBusterStrikeDamage(LivingEntity sourceentity, LivingEntity entity, ItemStack itemstack, Level level) {
        float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf(this.m_43299_())).floatValue();
        float bonusDamage = baseDamage * 0.7f;
        ModUtils.applyBonusDamage(sourceentity, entity, itemstack, bonusDamage);
        if (sourceentity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceentity;
            boolean shouldIncrementCounter = false;
            boolean isCreative = player.m_150110_().f_35937_;
            if (isCreative) {
                shouldIncrementCounter = true;
            } else if (entity instanceof Player) {
                shouldIncrementCounter = true;
            } else if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                boolean bl = shouldIncrementCounter = mob.m_5448_() == player;
            }
            if (shouldIncrementCounter) {
                AdvancementsHandler.incrementEntityCounterAndCheckAdvancement(player, entity, "buster_strike_count", "ruder_buster", 3);
            }
            itemstack.m_41622_(3, sourceentity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)new CustomVerticalSweepParticleData(1.8f, 0.0f, 0.0f, 1.0f), entity.m_20185_(), entity.m_20186_() + (double)entity.m_20206_() * 0.5, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12313_, sourceentity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f);
            this.spawnAttackBlockParticles(serverLevel, entity.m_20183_(), entity);
        }
        this.applyDepletionEffect(level, sourceentity);
    }

    public void spawnAttackBlockParticles(ServerLevel serverLevel, BlockPos impactPos, LivingEntity entity) {
        boolean isInWater = entity.m_5842_();
        BlockPos basePos = impactPos.m_7495_();
        int halfSize = 1;
        for (int x = -halfSize; x <= halfSize; ++x) {
            for (int z = -halfSize; z <= halfSize; ++z) {
                BlockPos pos = basePos.m_7918_(x, 0, z);
                BlockState state = serverLevel.m_8055_(pos);
                if (state.m_60795_() || !serverLevel.m_8055_(pos.m_7494_()).m_60795_()) continue;
                SimpleParticleType particle = isInWater ? ParticleTypes.f_123795_ : new BlockParticleOption(ParticleTypes.f_123794_, state);
                int particleCount = isInWater ? 6 : 3;
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = serverLevel.f_46441_.m_188583_() * (double)0.3f;
                    double offsetY = serverLevel.f_46441_.m_188500_() * 0.5 + 0.5;
                    double offsetZ = serverLevel.f_46441_.m_188583_() * (double)0.3f;
                    serverLevel.m_8767_((ParticleOptions)particle, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 1.0 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, (double)0.1f, (double)0.1f, (double)0.1f, 0.0);
                }
            }
        }
    }

    public void applyDepletionEffect(Level level, LivingEntity sourceentity) {
        if (!((Boolean)JaamsWeaponryCommonConfiguration.DEPLETION.get()).booleanValue() || level.m_5776_()) {
            return;
        }
        sourceentity.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get(), 60, 2, false, false, true));
    }

    private void performSweepAttack(ItemStack itemstack, LivingEntity entity, Player player) {
        SweepAttackHandler.performSweepAttack(itemstack, entity, (LivingEntity)player, 1.0f, 0.5f, 1, true, SoundEvents.f_12317_, new CustomVerticalSweepParticleData(1.0f, 0.0f, 0.0f, 1.0f), nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
    }
}

