/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class ButterflySwordItem
extends SwordItem {
    private static final String NBT_HITS = "ButterflyHits";
    private static final String NBT_SPEED_MOD = "ButterflySpeedMod";
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("FA233E1C-5F8C-4180-4865-B01BBCCE9785");

    public ButterflySwordItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        float speedMod;
        Multimap baseModifiers = super.getAttributeModifiers(slot, stack);
        HashMultimap modifiers = HashMultimap.create((Multimap)baseModifiers);
        if (slot == EquipmentSlot.MAINHAND && (speedMod = stack.m_41784_().m_128457_(NBT_SPEED_MOD)) != 0.0f) {
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(SPEED_MODIFIER_UUID, "Butterfly speed modifier", (double)speedMod, AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isFullyCharged;
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean bl = isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        if (isFullyCharged) {
            this.incrementHitCounter(itemstack);
        }
        this.updateItemNbt(itemstack);
        return retval;
    }

    private void incrementHitCounter(ItemStack itemstack) {
        CompoundTag nbt = itemstack.m_41784_();
        int hits = nbt.m_128451_(NBT_HITS) + 1;
        nbt.m_128405_(NBT_HITS, hits);
    }

    private void updateItemNbt(ItemStack itemstack) {
        CompoundTag nbt = itemstack.m_41784_();
        int hits = nbt.m_128451_(NBT_HITS);
        float currentSpeedMod = nbt.m_128457_(NBT_SPEED_MOD);
        if (hits >= 4) {
            hits = 0;
            currentSpeedMod = 0.0f;
        } else {
            currentSpeedMod += 0.2f;
        }
        nbt.m_128405_(NBT_HITS, hits);
        nbt.m_128350_(NBT_SPEED_MOD, currentSpeedMod);
        itemstack.m_41751_(nbt);
    }

    public static String getNbtHitsKey() {
        return NBT_HITS;
    }

    public static String getNbtSpeedModKey() {
        return NBT_SPEED_MOD;
    }
}

