/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ClawItem
extends SwordItem {
    public static int ARMOR_DAMAGE_AMOUNT = 3;
    public static float ARMOR_DAMAGE_CHANCE = 0.6f;
    public static float BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static float BACKSTAB_MULTIPLIER_SNEAKING = 2.5f;
    public static float BACKSTAB_MULTIPLIER_INVISIBLE = 3.0f;
    public static float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.5f;
    public static float BACKSTAB_DURABILITY_PENALTY = 3.0f;
    public static float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static double BACKSTAB_MAX_DISTANCE = 2.0;
    public static double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    public static float WEAKNESS_CHANCE = 0.1f;
    public static int WEAKNESS_DURATION = 60;
    public static int WEAKNESS_LEVEL = 1;
    public static int RIGHT_CLICK_COOLDOWN = 40;
    public static float DARKNESS_BONUS = 0.5f;
    public static float MOVING_TARGET_PENALTY = 0.2f;
    public static float RIGHT_CLICK_DAMAGE_BONUS = 5.0f;

    public ClawItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && BackstabHandler.isBackstab((LivingEntity)player, target, BACKSTAB_MAX_DISTANCE, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, BACKSTAB_DURABILITY_PENALTY, RIGHT_CLICK_DURABILITY_MULTIPLIER, RIGHT_CLICK_FORWARD_IMPULSE, WEAKNESS_CHANCE, WEAKNESS_DURATION, WEAKNESS_LEVEL, BACKSTAB_MULTIPLIER_NORMAL, BACKSTAB_MULTIPLIER_SNEAKING, BACKSTAB_MULTIPLIER_INVISIBLE, BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE, DARKNESS_BONUS, MOVING_TARGET_PENALTY, RIGHT_CLICK_DAMAGE_BONUS);
                player.m_36335_().m_41524_((Item)this, RIGHT_CLICK_COOLDOWN);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged && BackstabHandler.isBackstab((LivingEntity)player, entity, BACKSTAB_MAX_DISTANCE, BACKSTAB_MAX_ANGLE)) {
            BackstabHandler.performBackstab((LivingEntity)player, entity, itemstack, level, BACKSTAB_DURABILITY_PENALTY, WEAKNESS_CHANCE, WEAKNESS_DURATION, WEAKNESS_LEVEL, BACKSTAB_MULTIPLIER_NORMAL, BACKSTAB_MULTIPLIER_SNEAKING, BACKSTAB_MULTIPLIER_INVISIBLE, BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE, DARKNESS_BONUS, MOVING_TARGET_PENALTY);
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (isFullyCharged && level.f_46441_.m_188501_() < ARMOR_DAMAGE_CHANCE) {
            BreakingHandler.damageArmorPieces(entity, ARMOR_DAMAGE_AMOUNT, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
        }
        return retval;
    }

    public float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

