/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.entity.CleaverProjectileEntity;
import net.jaams.jaams_weaponry.handler.mechanics.DisablerHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class CleaverItem
extends SwordItem {
    public static int BASE_DISABLE_TICKS = 60;
    public static int DISABLABLE_ITEM_DISABLE_TICKS = 120;
    public static int CRITICAL_HIT_BONUS_TICKS = 60;
    public static final int MAX_DRAW_DURATION = 20;
    public static final float MIN_PROJECTILE_SPEED = 0.4f;
    public static final float MAX_PROJECTILE_SPEED = 1.8f;

    public CleaverItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.SPEAR;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44955_ || enchantment == Enchantments.f_44959_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged) {
            CleaverItem.applyItemDisable(entity, isCritical);
        }
        return retval;
    }

    public static void applyItemDisable(LivingEntity entity, boolean isCriticalHit) {
        int disableTicks = BASE_DISABLE_TICKS;
        int disablableItemTicks = DISABLABLE_ITEM_DISABLE_TICKS;
        if (isCriticalHit) {
            disableTicks += CRITICAL_HIT_BONUS_TICKS;
            disablableItemTicks += CRITICAL_HIT_BONUS_TICKS;
        }
        if (entity.m_6117_()) {
            ItemStack activeItem = entity.m_21211_();
            if (!activeItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(activeItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, disablableItemTicks);
                } else if (!(activeItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, disableTicks);
                }
            }
        } else {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (!mainHandItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(mainHandItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, disablableItemTicks);
                } else if (!(mainHandItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, disableTicks);
                }
            } else if (!offHandItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(offHandItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, disablableItemTicks);
                } else if (!(offHandItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, disableTicks);
                }
            }
        }
    }

    public void m_5551_(ItemStack itemstack, Level level, LivingEntity entity, int durationUsed) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int remainingDuration = this.m_8105_(itemstack) - durationUsed;
            if (remainingDuration >= 5 && !level.f_46443_) {
                float power = CleaverItem.getPowerForTime(remainingDuration);
                float speed = this.calculateProjectileSpeed(power);
                boolean isCreative = player.m_150110_().f_35937_;
                boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack) > 0;
                int projectileCount = hasMultishot ? 3 : 1;
                float[] shotPitches = CleaverItem.generateShotPitches(level.m_213780_(), projectileCount);
                int pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)itemstack);
                for (int i = 0; i < projectileCount; ++i) {
                    CleaverProjectileEntity projectile = new CleaverProjectileEntity(level, (LivingEntity)player, itemstack.m_41777_());
                    int slotIndex = entity.m_7655_() == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                    projectile.setOriginalSlotIndex(slotIndex);
                    if (ModUtils.isProjectileCritical(player, power)) {
                        projectile.setCritical(true);
                    }
                    projectile.setPiercingLevel(projectile.getPiercingLevel() + pierceLevel);
                    if (hasMultishot) {
                        AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                        if (i != 0) {
                            projectile.getPersistentData().m_128379_("IsMultishotClone", true);
                        }
                        float spreadAngle = 10.0f;
                        float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                        Vec3 upVector = player.m_20289_(1.0f);
                        Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis(rotation * (float)Math.PI / 180.0f, (float)upVector.f_82479_, (float)upVector.f_82480_, (float)upVector.f_82481_);
                        Vec3 viewVector = player.m_20252_(1.0f);
                        Vector3f rotatedVector = new Vector3f((float)viewVector.f_82479_, (float)viewVector.f_82480_, (float)viewVector.f_82481_).rotate((Quaternionfc)rotationQuaternion);
                        if (i == 0) {
                            float forwardOffset = 1.0f;
                            Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                            projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                        }
                        projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), speed, 1.0f);
                    } else {
                        projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                        projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, speed, 1.0f);
                    }
                    projectile.setWeaponItem(itemstack.m_41777_());
                    level.m_7967_((Entity)projectile);
                    SoundEvent shootSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:cleaver_throw"));
                    level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), shootSound != null ? shootSound : SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                }
                if (!isCreative) {
                    itemstack.m_41622_(1, (LivingEntity)player, brokenItemStack -> brokenItemStack.m_21190_(entity.m_7655_()));
                    itemstack.m_41774_(1);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    private float calculateProjectileSpeed(float power) {
        float speedRange = 1.4f;
        float scaledPower = power * power;
        return 0.4f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[projectileCount];
        for (int i = 0; i < projectileCount; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }
}

