/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.Arrays;
import java.util.List;
import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.handler.mechanics.ItemSwitchHandler;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class DaggerItem
extends SwordItem {
    public static final float BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING = 2.5f;
    public static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.0f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.5f;
    public static final float BACKSTAB_DURABILITY_PENALTY = 3.0f;
    public static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static final double BACKSTAB_MAX_DISTANCE = 2.0;
    public static final double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    public static final float WEAKNESS_CHANCE = 0.0f;
    public static final int WEAKNESS_DURATION = 60;
    public static final int WEAKNESS_LEVEL = 1;
    public static final int RIGHT_CLICK_COOLDOWN = 20;
    public static final float DARKNESS_BONUS = 1.5f;
    public static final float MOVING_TARGET_PENALTY = 0.5f;
    public static final double GRACE_PERIOD_SECONDS = 0.2;
    public static final float RIGHT_CLICK_DAMAGE_BONUS = 2.5f;

    public DaggerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44983_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6047_()) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            if (itemId == null || !itemId.m_135827_().equals("jaams_weaponry")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String path = itemId.m_135815_();
            if (path.endsWith("_reverse")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String targetPath = path + "_reverse";
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", targetPath);
            Item targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            if (targetItem == ItemStack.f_41583_.m_41720_()) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            if (!world.m_5776_()) {
                List<ResourceLocation> noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:daggers"), new ResourceLocation("jaams_weaponry:reverse_daggers"));
                String soundPath = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
                ItemSwitchHandler.switchItem((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack.m_41720_(), targetItem, 20, 20, soundPath, null, noCooldownTags);
            }
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (BackstabHandler.isBackstab((LivingEntity)player, target, 2.0, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                if (!level.m_5776_()) {
                    float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                    BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, 3.0f, 2.0f, 0.8f, 0.0f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 1.5f, 0.5f, 2.5f);
                    player.m_36335_().m_41524_((Item)this, 20);
                    player.m_6674_(hand);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isFullyCharged = sourceentity instanceof Player ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        Level level = entity.m_9236_();
        if (isFullyCharged && BackstabHandler.isBackstab(sourceentity, entity, 2.0, BACKSTAB_MAX_ANGLE)) {
            float baseDamage = sourceentity instanceof Player ? this.calculateDamage(itemstack) + (float)(sourceentity.m_21133_(Attributes.f_22281_) / 2.0) : (float)sourceentity.m_21133_(Attributes.f_22281_);
            this.applyBackstabEffects(itemstack, entity, sourceentity, level, baseDamage);
        }
        return retval;
    }

    public void applyBackstabEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, Level level, float baseDamage) {
        BackstabHandler.performBackstab(sourceentity, entity, itemstack, level, 3.0f, 0.0f, 60, 1, 2.0f, 2.5f, 3.0f, 3.5f, 1.5f, 0.5f);
    }

    public float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

