/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.SlamAttackHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SmashAttackHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class GreathammerItem
extends PickaxeItem {
    public static final float DAMAGE_PER_BLOCK = 2.0f;
    public static final float MAX_BONUS_DAMAGE = 175.0f;
    public static final float RESIDUAL_DAMAGE_BASE = 2.5f;
    public static final float RESIDUAL_DAMAGE_PER_BLOCK = 0.35f;
    public static final float MAX_RESIDUAL_DAMAGE = 40.0f;
    public static final float SMASH_RADIUS = 2.5f;
    public static final float MIN_KNOCKBACK_STRENGTH = 0.1f;
    public static final float MAX_KNOCKBACK_STRENGTH = 0.5f;
    public static final float KNOCKBACK_SCALING_FACTOR = 0.03f;
    public static final int PARTICLE_COUNT = 20;
    public static final float MIN_FALL_DISTANCE = 3.5f;
    public static final float MAX_EFFECTIVE_FALL_DISTANCE = 250.0f;
    public static final float SHAKE_INTENSITY = 4.5f;
    public static final int SHAKE_RESET_DELAY = 10;
    public static final float ALLY_DAMAGE_MULTIPLIER = 0.1f;
    public static final int SMASH_DURABILITY_DAMAGE_BASE = 3;
    public static final float SMASH_DURABILITY_DAMAGE_PER_BLOCK = 1.0f;
    public static final int SMASH_MAX_DURABILITY_DAMAGE = 1000;
    public static final int KNOCKED_UP_DURATION = 120;
    public static final int KNOCKED_UP_LEVEL = 1;
    public static final float KNOCKED_UP_BASE_CHANCE = 0.2f;
    public static final float KNOCKED_UP_CHANCE_PER_BLOCK = 0.04f;
    public static final float KNOCKED_UP_CRITICAL_CHANCE = 0.5f;
    public static final int DEPLETION_DURATION = 120;
    public static final int DEPLETION_LEVEL = 2;
    public static final float DEPLETION_CHANCE = 1.0f;
    public static final float DEPLETION_BLOCKS_PER_LEVEL = 20.0f;
    public static final float DEPLETION_TICKS_PER_BLOCK = 4.0f;
    public static final int DEPLETION_MAX_LEVEL = 6;
    public static final int DEPLETION_MAX_DURATION = 1200;
    public static final boolean ENABLE_DEPLETION = true;
    public static boolean PLAY_SOUND = true;
    public static boolean SHOW_PARTICLES = true;
    public static final int PARTICLE_AREA_SIZE = 3;
    public static final int PARTICLES_PER_BLOCK = 3;
    public static final float PARTICLE_OFFSET_SCALE = 0.3f;
    public static final float PARTICLE_SPEED = 0.1f;
    public static final boolean ENABLE_ATTACK_PARTICLES = true;
    public static final float SLAM_MAX_BONUS_DAMAGE = 150.0f;
    public static final float SLAM_MAX_RESIDUAL_DAMAGE = 35.0f;
    public static final float SLAM_RADIUS = 3.0f;
    public static final float SLAM_MIN_KNOCKBACK_STRENGTH = 0.15f;
    public static final float SLAM_MAX_KNOCKBACK_STRENGTH = 0.6f;
    public static final float SLAM_KNOCKBACK_SCALING_FACTOR = 0.04f;
    public static final int SLAM_PARTICLE_COUNT = 35;
    public static final float SLAM_SHAKE_INTENSITY = 5.0f;
    public static final int SLAM_SHAKE_RESET_DELAY = 12;
    public static final int SLAM_DURABILITY_DAMAGE_BASE = 4;
    public static final int SLAM_MAX_DURABILITY_DAMAGE = 1200;
    public static final float SLAM_EXHAUSTION = 0.5f;
    public static final float SLAM_DEPLETION_CHANCE = 1.0f;
    public static final int SLAM_DEPLETION_DURATION = 160;
    public static final int SLAM_DEPLETION_LEVEL = 4;
    public static final int SLAM_DEPLETION_MAX_LEVEL = 8;
    public static final int SLAM_DEPLETION_MAX_DURATION = 1000;
    public static final boolean SLAM_ENABLE_DEPLETION = true;
    public static final float SLAM_PLAYER_VERTICAL_IMPULSE = 0.9f;
    public static final float SLAM_ENTITY_VERTICAL_IMPULSE = 0.7f;
    public static final int SLAM_COOLDOWN_TICKS = 160;
    public static final float SLAM_BASE_DAMAGE_MULTIPLIER = 0.6f;
    public static final float OFFHAND_COOLDOWN_MULTIPLIER = 1.5f;
    public static final float OFFHAND_POWER_MULTIPLIER = 0.7f;

    public GreathammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.PICKAXE_DIG) || toolAction.equals(ToolActions.SWORD_SWEEP);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44981_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        Player player;
        block5: {
            block4: {
                if (!(attacker instanceof Player)) break block4;
                player = (Player)attacker;
                if (target != null) break block5;
            }
            return super.m_7579_(itemStack, target, attacker);
        }
        float attackStrength = player.m_36403_(0.5f);
        boolean isCritical = ModUtils.isCritical(player, (Entity)target, attackStrength);
        Level level = target.m_9236_();
        if (itemStack.m_41611_().getString().toLowerCase().equals("[bonk]")) {
            ModUtils.playSound((Entity)target, "jaams_weaponry:bonk");
        }
        this.applySmashLogic(player, target, itemStack, attackStrength);
        this.applyAttackEffects(player, target, itemStack, attackStrength);
        return super.m_7579_(itemStack, target, attacker);
    }

    public void applySmashLogic(Player player, LivingEntity entity, ItemStack itemstack, float attackStrength) {
        if (player.f_19789_ >= 3.5f && !player.m_20069_() && !player.m_20077_()) {
            SmashAttackHandler.applySmashLogic((LivingEntity)player, entity, itemstack, attackStrength, player.f_19789_, 2.0f, 175.0f, 2.5f, 0.35f, 40.0f, 2.5f, 0.1f, 0.5f, 0.03f, 20, 250.0f, 4.5f, 10, 0.1f, 3, 1.0f, 1000, 0.2f, 0.04f, 120, 1, 1.0f, 2, 120, 20.0f, 4.0f, 6, 1200, true);
        }
    }

    public void applyAttackEffects(Player player, LivingEntity entity, ItemStack itemstack, float attackStrength) {
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, attackStrength);
        Level level = player.m_9236_();
        if (isCritical) {
            SmashAttackHandler.applyCriticalKnockedUpEffect((LivingEntity)player, entity, 0.5f, 120, 1);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnAttackBlockParticles(serverLevel, entity.m_20183_(), entity);
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        ItemStack itemStack = context.m_43722_();
        BlockPos impactPos = context.m_8083_();
        InteractionHand hand = context.m_43724_();
        if (player == null || itemStack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_() && player.m_20096_() && !player.m_36335_().m_41519_((Item)this)) {
            float attackStrength = player.m_36403_(0.5f);
            if (attackStrength >= 0.3f) {
                if (!level.m_5776_()) {
                    this.activateSlamAttack((ServerPlayer)player, level, itemStack, impactPos, hand);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void activateSlamAttack(ServerPlayer player, Level level, ItemStack itemStack, BlockPos impactPos, InteractionHand hand) {
        boolean isOffhand = hand == InteractionHand.OFF_HAND;
        float attackStrength = player.m_36403_(0.5f);
        float intensityFactor = Math.max(0.3f, attackStrength);
        float powerMultiplier = isOffhand ? 0.7f : 1.0f;
        SlamAttackHandler.applyAreaAttack((Player)player, level, itemStack, impactPos, attackStrength, 0.6f * intensityFactor * powerMultiplier, 150.0f * intensityFactor * powerMultiplier, 35.0f * intensityFactor * powerMultiplier, 3.0f * powerMultiplier, 0.15f * intensityFactor * powerMultiplier, 0.6f * intensityFactor * powerMultiplier, 0.04f, Math.max(1, (int)(35.0f * intensityFactor * powerMultiplier)), 5.0f * intensityFactor * powerMultiplier, 12, 4, 1200, 0.5f, 1.0f, 4, 160, 8, 1000, true, 0.9f * intensityFactor * powerMultiplier, 0.7f * intensityFactor * powerMultiplier);
        int cooldownTicks = isOffhand ? 240 : 160;
        player.m_36335_().m_41524_((Item)this, cooldownTicks);
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof GreathammerItem)) continue;
            player.m_36335_().m_41524_(stack.m_41720_(), cooldownTicks);
        }
        ItemStack offHandStack = player.m_21206_();
        if (!offHandStack.m_41619_()) {
            player.m_36335_().m_41524_(offHandStack.m_41720_(), cooldownTicks / 2);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (SHOW_PARTICLES) {
                this.spawnAttackBlockParticles(serverLevel, impactPos, (LivingEntity)player);
            }
        }
        player.f_8906_.m_9829_((Packet)new ClientboundAnimatePacket((Entity)player, hand == InteractionHand.MAIN_HAND ? 0 : 3));
        player.m_36334_();
    }

    public void spawnAttackBlockParticles(ServerLevel serverLevel, BlockPos impactPos, LivingEntity entity) {
        boolean isInWater = entity.m_5842_();
        BlockPos basePos = impactPos.m_7495_();
        int halfSize = 1;
        for (int x = -halfSize; x <= halfSize; ++x) {
            for (int z = -halfSize; z <= halfSize; ++z) {
                BlockPos pos = basePos.m_7918_(x, 0, z);
                BlockState state = serverLevel.m_8055_(pos);
                if (state.m_60795_() || !serverLevel.m_8055_(pos.m_7494_()).m_60795_()) continue;
                SimpleParticleType particle = isInWater ? ParticleTypes.f_123795_ : new BlockParticleOption(ParticleTypes.f_123794_, state);
                int particleCount = isInWater ? 6 : 3;
                for (int i = 0; i < particleCount; ++i) {
                    double offsetX = serverLevel.f_46441_.m_188583_() * (double)0.3f;
                    double offsetY = serverLevel.f_46441_.m_188500_() * 0.5 + 0.5;
                    double offsetZ = serverLevel.f_46441_.m_188583_() * (double)0.3f;
                    serverLevel.m_8767_((ParticleOptions)particle, (double)pos.m_123341_() + 0.5 + offsetX, (double)pos.m_123342_() + 1.0 + offsetY, (double)pos.m_123343_() + 0.5 + offsetZ, 1, (double)0.1f, (double)0.1f, (double)0.1f, 0.0);
                }
            }
        }
    }
}

