/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.UUID;
import net.jaams.jaams_weaponry.handler.events.AdvancementsHandler;
import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;

public class GreatswordItem
extends SwordItem {
    public static final float HELD_ITEM_DAMAGE_CHANCE = 0.3f;
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 4;
    private static final String NBT_HITS = "GreatswordHits";
    private static final String NBT_DAMAGE_MOD = "GreatswordDamageMod";
    private static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

    public GreatswordItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isDead;
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        boolean bl = isDead = entity.m_21223_() <= 0.0f;
        if (isFullyCharged) {
            this.applyChargedAttackEffects(itemstack, entity, sourceentity, isCritical, isDead);
        }
        this.updateItemNbt(itemstack);
        return retval;
    }

    private void applyChargedAttackEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, boolean isCritical, boolean isDead) {
        Level level = entity.m_9236_();
        CompoundTag nbt = itemstack.m_41784_();
        int hits = nbt.m_128451_(NBT_HITS) + 1;
        float knockbackForce = 0.2f + (float)hits * 0.2f;
        entity.m_147240_((double)knockbackForce, sourceentity.m_20185_() - entity.m_20185_(), sourceentity.m_20189_() - entity.m_20189_());
        float damageChance = 0.3f + (float)hits * 0.3f;
        int damageAmount = 4 + hits * 4;
        if (level.f_46441_.m_188501_() < damageChance) {
            BreakingHandler.damageHeldItem(entity, damageAmount);
        }
        if (hits == 3 && isDead && sourceentity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)sourceentity;
            this.checkAndGrantAdvancement(player, entity);
        }
        nbt.m_128405_(NBT_HITS, hits);
    }

    private void updateItemNbt(ItemStack itemstack) {
        CompoundTag nbt = itemstack.m_41784_();
        int hits = nbt.m_128451_(NBT_HITS);
        float currentDamageMod = nbt.m_128457_(NBT_DAMAGE_MOD);
        if (hits >= 3) {
            hits = 0;
            currentDamageMod = 0.0f;
        } else {
            currentDamageMod += 2.5f;
        }
        nbt.m_128405_(NBT_HITS, hits);
        nbt.m_128350_(NBT_DAMAGE_MOD, currentDamageMod);
        itemstack.m_41751_(nbt);
    }

    private void checkAndGrantAdvancement(ServerPlayer player, LivingEntity entity) {
        Advancement advancement;
        boolean shouldGrantAdvancement = false;
        boolean isCreative = player.m_150110_().f_35937_;
        if (isCreative) {
            shouldGrantAdvancement = true;
        } else if (entity instanceof Player) {
            shouldGrantAdvancement = true;
        } else if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            boolean bl = shouldGrantAdvancement = mob.m_5448_() == player;
        }
        if (shouldGrantAdvancement && (advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("jaams_weaponry", "clavar_la_espada"))) != null && !player.m_8960_().m_135996_(advancement).m_8193_()) {
            AdvancementsHandler.grantAdvancement(player, "clavar_la_espada");
        }
    }

    public static String getNbtHitsKey() {
        return NBT_HITS;
    }

    public static String getNbtDamageModKey() {
        return NBT_DAMAGE_MOD;
    }
}

