/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.List;
import javax.annotation.Nullable;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.handler.guns.GunActionsHandler;
import net.jaams.jaams_weaponry.packets.GunInventoryPacket;
import net.jaams.jaams_weaponry.packets.GunShootPacket;
import net.jaams.jaams_weaponry.util.ModEnums;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.ItemStackHandler;

public abstract class GunBaseItem
extends Item {
    public GunBaseItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.CUSTOM;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.m_41462_();
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player entity, InteractionHand hand) {
        ItemStack itemStack = entity.m_21120_(hand);
        if (entity.m_36335_().m_41519_(itemStack.m_41720_())) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (hand == InteractionHand.OFF_HAND && ModUtils.isEntityInBattleMode((Entity)entity)) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (world.m_5776_() && ((Boolean)JaamsWeaponryCommonConfiguration.ENABLEGUNINVENTORY.get()).booleanValue()) {
            boolean isKeyPressed = ((ModEnums.KeyOption)((Object)JaamsWeaponryClientConfiguration.GUNINVKEY.get())).isPressed();
            if (isKeyPressed) {
                JaamsWeaponryMod.PACKET_HANDLER.sendToServer((Object)new GunInventoryPacket(hand));
            } else {
                int provisionalCooldown = 10;
                JaamsWeaponryMod.PACKET_HANDLER.sendToServer((Object)new GunShootPacket(hand, provisionalCooldown));
                entity.m_36335_().m_41524_(itemStack.m_41720_(), provisionalCooldown);
            }
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)true);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_6883_(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(itemstack, world, entity, slot, selected);
        GunActionsHandler.updateAmmoCount(itemstack);
        if (!itemstack.m_41782_()) {
            CompoundTag nbt = itemstack.m_41784_();
            nbt.m_128405_("Durability", itemstack.m_41776_());
        }
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> nbt.m_128365_("Inventory", (Tag)((ItemStackHandler)capability).serializeNBT()));
        nbt.m_128405_("Durability", stack.m_41773_());
        return nbt;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt != null) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> ((ItemStackHandler)capability).deserializeNBT(nbt.m_128469_("Inventory")));
            if (nbt.m_128425_("Durability", 3)) {
                stack.m_41721_(nbt.m_128451_("Durability"));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        if (stack.m_204117_(ModTags.GUNS)) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
                for (int i = 0; i < 3; ++i) {
                    MutableComponent textComponent;
                    MutableComponent iconComponent;
                    ItemStack slotItem = handler.getStackInSlot(i);
                    if (slotItem.m_41619_()) continue;
                    Style style = Style.f_131099_;
                    if (i == 1) {
                        itemName = slotItem.m_41786_().getString();
                        int bulletCount = slotItem.m_41613_();
                        iconComponent = Component.m_237113_((String)"\ufff1").m_130938_(s -> s.m_131150_(new ResourceLocation("jaams_weaponry", "default")));
                        textComponent = Component.m_237113_((String)(" " + itemName + " x" + bulletCount));
                        style = style.m_131148_(TextColor.m_131266_((int)16766720));
                    } else {
                        itemName = slotItem.m_41786_().getString();
                        int durability = slotItem.m_41776_() - slotItem.m_41773_();
                        int maxDurability = slotItem.m_41776_();
                        iconComponent = Component.m_237113_((String)"\ufff2").m_130938_(s -> s.m_131150_(new ResourceLocation("jaams_weaponry", "default")));
                        textComponent = Component.m_237113_((String)(" " + itemName + " " + durability + "/" + maxDurability));
                        style = style.m_131148_(TextColor.m_131266_((int)13467442));
                    }
                    MutableComponent combinedComponent = Component.m_237119_().m_7220_((Component)iconComponent).m_7220_((Component)textComponent.m_130948_(style));
                    tooltip.add((Component)combinedComponent);
                }
            });
        }
    }
}

