/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.SmashAttackHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class HammerItem
extends PickaxeItem {
    public static final float DAMAGE_PER_BLOCK = 2.5f;
    public static final float MAX_BONUS_DAMAGE = 75.0f;
    public static final float RESIDUAL_DAMAGE_BASE = 1.0f;
    public static final float RESIDUAL_DAMAGE_PER_BLOCK = 0.2f;
    public static final float MAX_RESIDUAL_DAMAGE = 20.0f;
    public static final float SMASH_RADIUS = 1.5f;
    public static final float MIN_KNOCKBACK_STRENGTH = 0.1f;
    public static final float MAX_KNOCKBACK_STRENGTH = 0.3f;
    public static final float KNOCKBACK_SCALING_FACTOR = 0.02f;
    public static final int PARTICLE_COUNT = 10;
    public static final int CRIT_PARTICLE_COUNT = 10;
    public static final float MIN_FALL_DISTANCE = 2.0f;
    public static final float MAX_EFFECTIVE_FALL_DISTANCE = 150.0f;
    public static final float SHAKE_INTENSITY = 2.5f;
    public static final int SHAKE_RESET_DELAY = 10;
    public static final float ALLY_DAMAGE_MULTIPLIER = 0.1f;
    public static final int SMASH_DURABILITY_DAMAGE_BASE = 1;
    public static final float SMASH_DURABILITY_DAMAGE_PER_BLOCK = 0.5f;
    public static final int SMASH_MAX_DURABILITY_DAMAGE = 1000;
    public static final int KNOCKED_UP_DURATION = 60;
    public static final int KNOCKED_UP_LEVEL = 1;
    public static final float KNOCKED_UP_BASE_CHANCE = 0.1f;
    public static final float KNOCKED_UP_CHANCE_PER_BLOCK = 0.02f;
    public static final float KNOCKED_UP_CRITICAL_CHANCE = 0.3f;
    public static final int DEPLETION_DURATION = 80;
    public static final int DEPLETION_LEVEL = 0;
    public static final float DEPLETION_CHANCE = 0.5f;
    public static final float DEPLETION_BLOCKS_PER_LEVEL = 40.0f;
    public static final float DEPLETION_TICKS_PER_BLOCK = 8.0f;
    public static final int DEPLETION_MAX_LEVEL = 3;
    public static final int DEPLETION_MAX_DURATION = 1200;
    public static final boolean ENABLE_DEPLETION = true;

    public HammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.PICKAXE_DIG || toolAction == ToolActions.SWORD_SWEEP;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_ || enchantment == Enchantments.f_44978_ || enchantment == Enchantments.f_44979_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44980_ || enchantment == Enchantments.f_44981_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, player.m_36403_(0.5f));
        float attackStrength = player.m_36403_(0.5f);
        Level level = entity.m_9236_();
        String displayName = itemstack.m_41611_().getString().toLowerCase();
        if (displayName.equalsIgnoreCase("[bonk]")) {
            ModUtils.playSound((Entity)entity, "jaams_weaponry:bonk");
        }
        this.applySmashLogic(player, entity, itemstack, attackStrength);
        this.applyAttackEffects(player, entity, itemstack, attackStrength);
        return retval;
    }

    public void applySmashLogic(Player player, LivingEntity entity, ItemStack itemstack, float attackStrength) {
        if (player.f_19789_ >= 2.0f && !player.m_20069_() && !player.m_20077_()) {
            SmashAttackHandler.applySmashLogic((LivingEntity)player, entity, itemstack, attackStrength, player.f_19789_, 2.5f, 75.0f, 1.0f, 0.2f, 20.0f, 1.5f, 0.1f, 0.3f, 0.02f, 10, 150.0f, 2.5f, 10, 0.1f, 1, 0.5f, 1000, 0.1f, 0.02f, 60, 1, 0.5f, 0, 80, 40.0f, 8.0f, 3, 1200, true);
        }
    }

    public void applyAttackEffects(Player player, LivingEntity entity, ItemStack itemstack, float attackStrength) {
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, attackStrength);
        if (isCritical) {
            SmashAttackHandler.applyCriticalKnockedUpEffect((LivingEntity)player, entity, 0.3f, 60, 1);
        }
    }
}

