/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.DisarmHandler;
import net.jaams.jaams_weaponry.handler.mechanics.PullTowardsHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class HookSwordItem
extends SwordItem {
    public static final float DISARM_CHANCE_SNEAKING = 0.2f;
    public static final float DISARM_CHANCE_NORMAL = 0.1f;
    public static final float CRITICAL_DISARM_MULTIPLIER = 2.0f;
    public static final float SELF_DISARM_CHANCE_PLAYER = 0.15f;
    public static final float SELF_DISARM_CHANCE_MOB = 0.05f;
    public static final float BASE_PULL_STRENGTH_ATTACKER = 6.0f;
    public static final float BASE_PULL_STRENGTH_ENEMY = 4.0f;
    public static final float ATTACK_STRENGTH_PULL_MODIFIER = 0.5f;
    public static final double BASE_MOVEMENT_SPEED = 0.1;
    public static final float MAX_PULL_DISTANCE = 8.0f;
    public static final double MAX_PULL_SPEED = 0.8;
    public static final float MAX_VERTICAL_PULL = 3.5f;
    public static final float VERTICAL_PULL_DAMPENING = 0.15f;
    public static final float PULL_DISTANCE_SCALING = 0.75f;
    public static final int DURABILITY_COST_DISARM = 3;
    public static final int DURABILITY_COST_PULL = 1;

    public HookSwordItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean isPlayer = sourceentity instanceof Player;
        float attackStrength = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) : 1.0f;
        boolean isCritical = isPlayer && ModUtils.isCritical((Player)sourceentity, (Entity)entity, attackStrength);
        boolean isFullyCharged = attackStrength >= 1.0f;
        Level level = entity.m_9236_();
        if (!level.f_46443_) {
            this.applyPull(entity, sourceentity, itemstack, attackStrength);
            if (isFullyCharged) {
                float baseDisarmChance = this.isSneaking(sourceentity) ? 0.2f : 0.1f;
                float disarmChance = isCritical ? baseDisarmChance * 2.0f : baseDisarmChance;
                this.handleDisarm(entity, sourceentity, itemstack, disarmChance);
            }
        }
        return retval;
    }

    private boolean isSneaking(LivingEntity sourceentity) {
        if (sourceentity instanceof Player) {
            return sourceentity.m_6144_();
        }
        return sourceentity.m_9236_().f_46441_.m_188501_() < 0.5f;
    }

    public void applyPull(LivingEntity entity, LivingEntity sourceentity, ItemStack itemstack, float attackStrength) {
        boolean isSneaking = this.isSneaking(sourceentity);
        float basePullStrength = isSneaking ? 4.0f : 6.0f;
        PullTowardsHandler.pullTowardsEnemy(entity, sourceentity, attackStrength, itemstack, basePullStrength, 8.0f, 0.8, 0.5f, 0.1, 3.5f, 0.15f, 0.75f, 1);
    }

    public void handleDisarm(LivingEntity entity, LivingEntity sourceentity, ItemStack itemstack, float disarmChance) {
        if (entity.m_9236_().f_46441_.m_188501_() < disarmChance) {
            float selfDisarmChance;
            float f = selfDisarmChance = sourceentity instanceof Player ? 0.15f : 0.05f;
            if (entity.m_9236_().f_46441_.m_188501_() < selfDisarmChance) {
                boolean disarmed;
                ItemStack heldItem = sourceentity.m_21205_();
                if (heldItem.m_41720_() == this) {
                    if (sourceentity instanceof Player) {
                        Player player = (Player)sourceentity;
                        player.m_36176_(heldItem.m_41777_(), true);
                        player.m_21008_(sourceentity.m_7655_(), ItemStack.f_41583_);
                        itemstack.m_41622_(3, sourceentity, p -> p.m_21190_(sourceentity.m_7655_()));
                    } else {
                        ItemEntity itemEntity = new ItemEntity(sourceentity.m_9236_(), sourceentity.m_20185_(), sourceentity.m_20186_(), sourceentity.m_20189_(), heldItem.m_41777_());
                        sourceentity.m_9236_().m_7967_((Entity)itemEntity);
                        sourceentity.m_21008_(sourceentity.m_7655_(), ItemStack.f_41583_);
                    }
                    return;
                }
                boolean bl = disarmed = DisarmHandler.disarmSlot(entity, sourceentity, EquipmentSlot.MAINHAND) || DisarmHandler.disarmSlot(entity, sourceentity, EquipmentSlot.OFFHAND);
                if (disarmed && sourceentity instanceof Player) {
                    itemstack.m_41622_(3, sourceentity, p -> p.m_21190_(sourceentity.m_7655_()));
                }
            }
        }
    }
}

