/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class KamaItem
extends SwordItem {
    public static final float ARMOR_BONUS_PERCENTAGE = 0.02f;
    public static final float CRITICAL_BONUS_PERCENTAGE = 0.05f;
    public static final int BASE_ARMOR_PENALTY_DURABILITY = 6;
    public static final int ARMOR_PIECE_PENALTY_DURABILITY = 6;
    public static final float MINIMUM_ARMOR_VALUE = 2.0f;
    public static final float ARMOR_PIERCING_CHANCE = 0.15f;

    public KamaItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != Enchantments.f_44983_ && super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (entity == null || sourceentity == null) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, player.m_36403_(0.5f));
        Level level = entity.m_9236_();
        if (isFullyCharged && level.f_46441_.m_188501_() < 0.15f) {
            this.applyArmorPiercingDamage(itemstack, entity, (LivingEntity)player, isCritical);
        }
        return super.m_7579_(itemstack, entity, sourceentity);
    }

    public void applyArmorPiercingDamage(ItemStack itemstack, LivingEntity target, LivingEntity attacker, boolean isCritical) {
        int armorPieces = this.countArmorPieces(target);
        float armorValue = (float)target.m_21133_(Attributes.f_22284_);
        if (armorPieces == 0 || armorValue <= 2.0f) {
            return;
        }
        float baseDamage = attacker.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf(this.calculateDamage(itemstack))).floatValue();
        float percentagePerPiece = isCritical ? 0.05f : 0.02f;
        float piercingDamage = baseDamage * ((float)armorPieces * percentagePerPiece);
        int durabilityPenalty = 6 + armorPieces * 6;
        Level level = target.m_9236_();
        ModUtils.applyPiercingDamage(attacker, target, itemstack, piercingDamage);
        if (!level.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, target.m_20185_(), target.m_20186_() + (double)target.m_20206_() * 0.5, target.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12313_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            itemstack.m_41622_(durabilityPenalty, attacker, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public int countArmorPieces(LivingEntity entity) {
        int count = 0;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack armor = entity.m_6844_(slot);
            if (armor.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

