/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.Comparator;
import java.util.List;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMobEffects;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.util.ModTags;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class KatanaItem
extends SwordItem {
    private static final float DASH_DISTANCE = 1.0f;
    private static final float DASH_SLASH_COOLDOWN = 80.0f;
    private static final float DASH_NO_TARGET_COOLDOWN = 40.0f;
    private static final int DASH_SLASH_DURABILITY_COST = 2;
    public static final int BREAK_RADIUS = 1;
    public static final float SWEEP_EFFECT_OFFSET = 1.5f;
    public static final int BLOCK_BREAK_DURABILITY_COST = 2;
    private static final float PLANT_BREAK_COOLDOWN = 15.0f;

    public KatanaItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemCooldowns cooldowns = player.m_36335_();
        HitResult hitResult = player.m_19907_(5.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            boolean blocksBroken;
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            UseOnContext context = new UseOnContext(player, hand, blockHitResult);
            BlockPos pos = context.m_8083_();
            BlockState clickedBlockState = level.m_8055_(pos);
            if (!cooldowns.m_41519_(stack.m_41720_()) && this.isBreakablePlant(clickedBlockState) && !level.m_5776_() && (blocksBroken = this.breakBlocksInArea(level, pos, player, stack))) {
                player.m_21011_(hand, true);
                stack.m_41622_(2, (LivingEntity)player, e -> e.m_21190_(hand));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.generateSweepEffect(serverLevel, player);
                }
                this.applyPlantBreakCooldown(player, hand);
                return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
            }
        }
        if (!cooldowns.m_41519_(stack.m_41720_()) && player.m_20142_() && player.m_20096_()) {
            if (!level.m_5776_()) {
                this.activateKatanaAbility(level, player, stack, hand);
            }
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void activateKatanaAbility(Level level, Player player, ItemStack itemStack, InteractionHand hand) {
        Vec3 startPos = player.m_20182_();
        this.applyDashMovement(player);
        Vec3 endPos = player.m_20182_();
        boolean hasTargets = this.applySlashAttack(level, player, itemStack, hand, startPos, endPos);
        this.applyDepletionEffect(level, player);
        this.playDashSound(level, player);
        if (!player.m_7500_()) {
            float exhaustion = 1.0f + player.m_217043_().m_188501_() * 1.0f;
            player.m_36324_().m_38703_(exhaustion);
        }
        if (hasTargets) {
            this.applyItemDamage(level, player, itemStack);
            ItemStack mainHandItem = player.m_21205_();
            ItemStack offHandItem = player.m_21206_();
            if (hand == InteractionHand.MAIN_HAND && offHandItem.m_204117_(ModTags.KATANAS)) {
                this.applyItemDamage(level, player, offHandItem);
            } else if (hand == InteractionHand.OFF_HAND && mainHandItem.m_204117_(ModTags.KATANAS)) {
                this.applyItemDamage(level, player, mainHandItem);
            }
            this.startSlashAnimation(player);
        }
        this.applyCooldowns(player, hand, hasTargets);
    }

    private void applyDashMovement(Player player) {
        double movementSpeed = player.m_21133_(Attributes.f_22279_);
        double knockbackResistance = Math.max(0.0, Math.min(1.0, player.m_21133_(Attributes.f_22278_)));
        double baseMovementSpeed = 0.1;
        double movementMultiplier = Math.max(0.1, movementSpeed / baseMovementSpeed);
        double knockbackModifier = 1.0 - knockbackResistance * 1.2;
        float speedMultiplier = (float)(movementMultiplier * knockbackModifier);
        speedMultiplier = Math.max(0.3f, speedMultiplier);
        float adjustedDashDistance = 1.0f * speedMultiplier;
        Vec3 look = player.m_20154_();
        player.m_20256_(new Vec3(look.f_82479_ * (double)adjustedDashDistance, 0.0, look.f_82481_ * (double)adjustedDashDistance));
        player.f_19864_ = true;
    }

    private void playDashSound(Level level, Player player) {
        if (!level.m_5776_()) {
            ResourceLocation dashSoundId = new ResourceLocation("jaams_weaponry:dash");
            SoundEvent dashSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(dashSoundId);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), dashSound != null ? dashSound : SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean applySlashAttack(Level level, Player player, ItemStack itemStack, InteractionHand hand, Vec3 startPos, Vec3 endPos) {
        double baseRange = 3.0;
        double range = baseRange + (double)itemStack.getEnchantmentLevel(Enchantments.f_44983_) * 0.5;
        AABB hitBox = new AABB(startPos, endPos).m_82377_(range, range * 0.5, range);
        List<Entity> entities = level.m_6443_(Entity.class, hitBox, e -> e != player && e instanceof LivingEntity && ((LivingEntity)e).m_6084_() && (!(e instanceof Player) || !((Player)e).m_7500_()) && !ModUtils.isAlliedEntity(player, e) && e.m_20182_().m_82557_(startPos) <= range * range * 2.0).stream().sorted(Comparator.comparingDouble(e -> e.m_20238_(player.m_20182_()))).toList();
        if (entities.isEmpty()) {
            this.startSlashAnimation(player);
            player.m_21011_(hand, false);
            return false;
        }
        itemStack.m_41784_().m_128379_("katanaslash", true);
        if (!level.m_5776_()) {
            SoundEvent slashSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:katana_slash"));
            level.m_5594_(null, player.m_20183_(), slashSound != null ? slashSound : SoundEvents.f_12317_, SoundSource.PLAYERS, 1.5f, 1.0f);
        }
        for (Entity target : entities) {
            JaamsWeaponryMod.queueServerWork(20, () -> this.applyEntityDamage(level, player, itemStack, target));
        }
        JaamsWeaponryMod.queueServerWork(20, () -> itemStack.m_41784_().m_128379_("katanaslash", false));
        return true;
    }

    private void applyEntityDamage(Level level, Player player, ItemStack itemStack, Entity target) {
        LivingEntity livingTarget;
        if (!(target instanceof LivingEntity) || ModUtils.isAlliedEntity(player, (Entity)(livingTarget = (LivingEntity)target)) || !livingTarget.m_6084_()) {
            return;
        }
        float baseDamage = this.calculateDamage(itemStack);
        float enchantmentDamage = this.calculateEnchantmentDamage(itemStack, livingTarget);
        float playerAttackDamage = (float)player.m_21133_(Attributes.f_22281_);
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offHandItem = player.m_21206_();
        boolean hasKatanaInBothHands = mainHandItem.m_204117_(ModTags.KATANAS) && offHandItem.m_204117_(ModTags.KATANAS);
        float damageMultiplier = hasKatanaInBothHands ? 2.5f : 1.0f;
        float totalDamage = (baseDamage + playerAttackDamage / 2.0f + enchantmentDamage) * 0.6f - 2.0f;
        if ((totalDamage *= damageMultiplier) > 0.0f) {
            livingTarget.m_6469_(this.createDamageSource(level, player), totalDamage);
            this.applySpecialEffects(level, livingTarget, itemStack);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                float size = 1.0f;
                double yOffset = (double)serverLevel.f_46441_.m_188501_() * 0.5 - 0.25;
                double particleY = livingTarget.m_20186_() + 1.0 + yOffset;
                serverLevel.m_8767_((ParticleOptions)new CustomSweepParticleData(r, g, b, size), livingTarget.m_20185_(), particleY, livingTarget.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                SoundEvent cutSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("jaams_weaponry:katana_slash_cut"));
                serverLevel.m_5594_(null, livingTarget.m_20183_(), cutSound != null ? cutSound : SoundEvents.f_12313_, SoundSource.PLAYERS, 1.5f, 1.0f);
            }
            if (livingTarget instanceof Mob) {
                Mob mob = (Mob)livingTarget;
                if (!player.m_7500_()) {
                    mob.m_6710_((LivingEntity)player);
                }
            }
        }
    }

    private float calculateEnchantmentDamage(ItemStack itemStack, LivingEntity target) {
        int baneLevel;
        int smiteLevel;
        float damage = 0.0f;
        int sharpnessLevel = itemStack.getEnchantmentLevel(Enchantments.f_44977_);
        if (sharpnessLevel > 0) {
            damage += 1.0f + (float)sharpnessLevel * 0.5f;
        }
        if ((smiteLevel = itemStack.getEnchantmentLevel(Enchantments.f_44978_)) > 0 && target.m_6336_() == MobType.f_21641_) {
            damage += (float)smiteLevel * 1.5f;
        }
        if ((baneLevel = itemStack.getEnchantmentLevel(Enchantments.f_44979_)) > 0 && target.m_6336_() == MobType.f_21642_) {
            damage += (float)baneLevel * 1.5f;
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 1));
        }
        return damage;
    }

    private void applyDepletionEffect(Level level, Player player) {
        if (!level.m_5776_() && ((Boolean)JaamsWeaponryCommonConfiguration.DEPLETION.get()).booleanValue()) {
            player.m_7292_(new MobEffectInstance((MobEffect)JaamsWeaponryModMobEffects.DEPLETION.get(), 40, 1, false, false, true));
        }
    }

    private void applyItemDamage(Level level, Player player, ItemStack itemStack) {
        if (!player.m_7500_() && itemStack.m_220157_(2, player.m_217043_(), null)) {
            itemStack.m_41774_(1);
            itemStack.m_41721_(0);
            if (!level.m_5776_()) {
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    private void startSlashAnimation(Player player) {
        ModUtils.applyAnimation((Entity)player, "katana", 10);
    }

    private void applyCooldowns(Player player, InteractionHand hand, boolean hasTargets) {
        ItemStack otherHandStack;
        ItemCooldowns cooldowns = player.m_36335_();
        float cooldownTicks = hasTargets ? 80.0f : 40.0f;
        ItemStack usedStack = player.m_21120_(hand);
        if (usedStack.m_41720_() instanceof KatanaItem) {
            cooldowns.m_41524_(usedStack.m_41720_(), (int)cooldownTicks);
        }
        ItemStack itemStack = otherHandStack = hand == InteractionHand.MAIN_HAND ? player.m_21206_() : player.m_21205_();
        if (otherHandStack.m_41720_() instanceof KatanaItem) {
            cooldowns.m_41524_(otherHandStack.m_41720_(), (int)cooldownTicks);
        }
    }

    private void applyPlantBreakCooldown(Player player, InteractionHand hand) {
        ItemCooldowns cooldowns = player.m_36335_();
        ItemStack usedStack = player.m_21120_(hand);
        if (usedStack.m_41720_() instanceof KatanaItem) {
            cooldowns.m_41524_(usedStack.m_41720_(), 15);
        }
    }

    private void applySpecialEffects(Level level, LivingEntity target, ItemStack itemStack) {
        int knockbackLevel;
        int fireAspectLevel = itemStack.getEnchantmentLevel(Enchantments.f_44981_);
        if (fireAspectLevel > 0) {
            target.m_20254_(10 + fireAspectLevel * 5);
        }
        if ((knockbackLevel = itemStack.getEnchantmentLevel(Enchantments.f_44980_)) > 0) {
            double knockbackStrength = (double)knockbackLevel * 0.5;
            Vec3 knockbackDirection = target.m_20182_().m_82546_(target.m_20182_()).m_82541_().m_82490_(knockbackStrength);
            target.m_5997_(knockbackDirection.f_82479_, knockbackDirection.f_82480_ + 0.1, knockbackDirection.f_82481_);
        }
    }

    private float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }

    private DamageSource createDamageSource(Level level, Player player) {
        ResourceKey damageTypeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("jaams_weaponry:slash"));
        Holder damageTypeHolder = (Holder)level.m_9598_().m_175515_(Registries.f_268580_).m_203636_(damageTypeKey).orElseThrow(() -> new IllegalStateException("Damage type not found: " + String.valueOf(damageTypeKey.m_135782_())));
        return new DamageSource(damageTypeHolder, (Entity)player);
    }

    private boolean breakBlocksInArea(Level level, BlockPos centerPos, Player player, ItemStack itemStack) {
        boolean blocksBroken = false;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos targetPos = centerPos.m_7918_(dx, 0, dz);
                BlockState blockState = level.m_8055_(targetPos);
                if (!this.isBreakablePlant(blockState)) continue;
                level.m_46953_(targetPos, true, (Entity)player);
                blocksBroken = true;
            }
        }
        return blocksBroken;
    }

    private void generateSweepEffect(ServerLevel serverLevel, Player player) {
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)player.m_20192_() * 0.5;
        double z = player.m_20189_();
        Vec3 lookDirection = player.m_20154_();
        double offsetX = lookDirection.f_82479_ * 1.5;
        double offsetY = 0.0;
        double offsetZ = lookDirection.f_82481_ * 1.5;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.1, 0.1, 0.1, 0.0);
        serverLevel.m_6263_(null, x + offsetX, y + offsetY, z + offsetZ, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private boolean isBreakablePlant(BlockState blockState) {
        return blockState.m_60734_() instanceof BambooStalkBlock || blockState.m_60734_() instanceof SugarCaneBlock || blockState.m_60734_() instanceof TallGrassBlock || blockState.m_60734_() instanceof DoublePlantBlock;
    }
}

