/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.handler.mechanics.BackstabHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class KatarItem
extends SwordItem {
    public static final float ARMOR_BONUS_PERCENTAGE = 0.05f;
    public static final float CRITICAL_BONUS_PERCENTAGE = 0.07f;
    public static final int BASE_ARMOR_PENALTY_DURABILITY = 1;
    public static final int ARMOR_PIECE_PENALTY_DURABILITY = 1;
    public static final float MINIMUM_ARMOR_VALUE = 4.0f;
    public static final float BACKSTAB_PIERCING_AMPLIFIER = 1.8f;
    public static final float BACKSTAB_MULTIPLIER_NORMAL = 2.5f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING = 3.0f;
    public static final float BACKSTAB_MULTIPLIER_INVISIBLE = 3.5f;
    public static final float BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 4.0f;
    public static final float HURT_ENEMY_BACKSTAB_MULTIPLIER_NORMAL = 2.0f;
    public static final float HURT_ENEMY_BACKSTAB_MULTIPLIER_SNEAKING = 2.4f;
    public static final float HURT_ENEMY_BACKSTAB_MULTIPLIER_INVISIBLE = 2.8f;
    public static final float HURT_ENEMY_BACKSTAB_MULTIPLIER_SNEAKING_INVISIBLE = 3.4f;
    public static final float BACKSTAB_DURABILITY_PENALTY = 5.0f;
    public static final float RIGHT_CLICK_DURABILITY_MULTIPLIER = 2.0f;
    public static final float RIGHT_CLICK_FORWARD_IMPULSE = 0.8f;
    public static final double BACKSTAB_MAX_DISTANCE = 2.0;
    public static final double BACKSTAB_MAX_ANGLE = Math.toRadians(45.0);
    public static final float WEAKNESS_CHANCE = 0.1f;
    public static final int WEAKNESS_DURATION = 60;
    public static final int WEAKNESS_LEVEL = 1;
    public static final int RIGHT_CLICK_COOLDOWN = 40;
    public static final float DARKNESS_BONUS = 0.5f;
    public static final float MOVING_TARGET_PENALTY = 0.2f;
    public static final double GRACE_PERIOD_SECONDS = 0.2;
    public static final float RIGHT_CLICK_DAMAGE_BONUS = 3.0f;

    public KatarItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44983_) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResult m_6880_(ItemStack itemstack, Player player, LivingEntity target, InteractionHand hand) {
        Level level = player.m_9236_();
        if (!level.f_46443_ && BackstabHandler.isBackstab((LivingEntity)player, target, 2.0, BACKSTAB_MAX_ANGLE)) {
            Player targetPlayer;
            if (target instanceof Player && (targetPlayer = (Player)target).m_7500_()) {
                return InteractionResult.PASS;
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                float baseDamage = this.calculateDamage(itemstack) + (float)(player.m_21133_(Attributes.f_22281_) / 2.0);
                BackstabHandler.performRightClickBackstab((LivingEntity)player, target, itemstack, level, baseDamage, 5.0f, 2.0f, 0.8f, 0.1f, 60, 1, 2.5f, 3.0f, 3.5f, 4.0f, 0.5f, 0.2f, 3.0f);
                player.m_36335_().m_41524_((Item)this, 40);
                player.m_6674_(hand);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        if (entity == null || sourceentity == null || !(sourceentity instanceof Player)) {
            return false;
        }
        Player player = (Player)sourceentity;
        boolean isFullyCharged = player.m_36403_(0.5f) >= 1.0f;
        boolean isCritical = ModUtils.isCritical(player, (Entity)entity, player.m_36403_(0.5f));
        Level level = entity.m_9236_();
        if (isFullyCharged) {
            boolean isBackstab = BackstabHandler.isBackstab((LivingEntity)player, entity, 2.0, BACKSTAB_MAX_ANGLE);
            float backstabMultiplier = isBackstab ? BackstabHandler.calculateBackstabMultiplier((LivingEntity)player, entity, level, 2.0f, 2.4f, 2.8f, 3.4f, 0.5f, 0.2f) : 1.0f;
            this.applyArmorPiercingDamage(itemstack, entity, (LivingEntity)player, isCritical, backstabMultiplier, isBackstab);
            if (isBackstab) {
                BackstabHandler.performBackstab((LivingEntity)player, entity, itemstack, level, 5.0f, 0.1f, 60, 1, 2.0f, 2.4f, 2.8f, 3.4f, 0.5f, 0.2f);
            }
        }
        return super.m_7579_(itemstack, entity, sourceentity);
    }

    public void applyArmorPiercingDamage(ItemStack itemstack, LivingEntity target, LivingEntity attacker, boolean isCritical, float backstabMultiplier, boolean isBackstab) {
        int armorPieces = this.countArmorPieces(target);
        float armorValue = (float)target.m_21133_(Attributes.f_22284_);
        if (armorPieces == 0 || armorValue <= 4.0f) {
            return;
        }
        if (target.m_9236_().m_213780_().m_188501_() >= 0.25f) {
            return;
        }
        float baseDamage = attacker.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf(this.calculateDamage(itemstack))).floatValue();
        float percentagePerPiece = isCritical ? 0.07f : 0.05f;
        float piercingMultiplier = backstabMultiplier > 1.0f ? 1.8f : 1.0f;
        float piercingDamage = baseDamage * ((float)armorPieces * percentagePerPiece * piercingMultiplier);
        int durabilityPenalty = 1 + armorPieces * 1;
        Level level = target.m_9236_();
        ModUtils.applyPiercingDamage(attacker, target, itemstack, piercingDamage);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            itemstack.m_41622_(durabilityPenalty, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    public int countArmorPieces(LivingEntity entity) {
        int count = 0;
        for (EquipmentSlot slot : new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack armor = entity.m_6844_(slot);
            if (armor.m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public float calculateDamage(ItemStack itemStack) {
        AttributeModifier modifier = itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().findFirst().orElse(null);
        return modifier != null ? (float)modifier.m_22218_() : 1.0f;
    }
}

