/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;

public class LongswordItem
extends SwordItem {
    private static final float DISTANCE_BONUS_PER_BLOCK = 0.1f;
    private static final float CRITICAL_BONUS_MULTIPLIER = 1.8f;
    private static final float MAX_BONUS_BLOCKS = 12.0f;
    private static final float MIN_DISTANCE_BLOCKS = 1.5f;
    private static final float TALL_ENTITY_BONUS = 0.2f;
    private static final float HEIGHT_DIFFERENCE_BONUS_PER_BLOCK = 0.1f;
    private static final int TALL_DURABILITY_COST = 2;
    private static final float DISTANCE_DURABILITY_COST_PER_BLOCK = 0.1f;

    public LongswordItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isFullyCharged;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean bl = isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        if (isFullyCharged) {
            sourceentity.getCapability(AmountProvider.AMOUNT).ifPresent(amount -> this.applyDamageBonuses(itemstack, entity, sourceentity, amount.getDamage(), isCritical));
        }
        return retval;
    }

    private void applyDamageBonuses(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical) {
        float heightDifference;
        float heightBonus;
        float distanceBonus;
        float tallBonus = entity.m_20191_().m_82376_() > 2.0 ? 0.2f : 0.0f;
        float totalBonus = tallBonus + (distanceBonus = ModUtils.calculateDistanceBonus(sourceentity, entity, isCritical, 12.0f, 1.5f, 0.1f, 1.8f)) + (heightBonus = (heightDifference = (float)Math.abs(sourceentity.m_20188_() - entity.m_20188_())) * 0.1f);
        if (totalBonus > 0.0f) {
            int totalDurabilityCost;
            ModUtils.applyBonusDamage(sourceentity, entity, itemstack, totalBonus * baseDamage);
            int n = totalDurabilityCost = tallBonus > 0.0f ? 2 : 0;
            if (distanceBonus > 0.0f || heightBonus > 0.0f) {
                float totalBlocks = (float)Math.min(Math.sqrt(Math.pow(sourceentity.m_20185_() - entity.m_20185_(), 2.0) + Math.pow(sourceentity.m_20189_() - entity.m_20189_(), 2.0)) + (double)heightDifference, 12.0);
                totalDurabilityCost += (int)Math.ceil(totalBlocks * 0.1f);
            }
            if (sourceentity instanceof Player) {
                itemstack.m_41622_(totalDurabilityCost, sourceentity, p -> p.m_21190_(p.m_7655_()));
            }
        }
    }
}

