/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.handler.mechanics.BreakingHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class MacheteItem
extends SwordItem {
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 4;
    public static final float HELD_ITEM_DAMAGE_CHANCE = 0.4f;
    public static final int ARMOR_DAMAGE_AMOUNT = 2;
    public static final float ARMOR_DAMAGE_CHANCE = 0.8f;
    public static final int BREAK_RADIUS = 1;
    public static final int BLOCK_BREAK_DURABILITY_COST = 1;
    public static final float SWEEP_EFFECT_OFFSET = 1.5f;
    private static final float PLANT_BREAK_COOLDOWN = 10.0f;

    public MacheteItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.HOE_DIG) || toolAction.equals(ToolActions.SWORD_DIG) || toolAction.equals(ToolActions.SWORD_SWEEP);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_7500_()) {
            return state.m_60734_() instanceof CropBlock || this.isBreakablePlant(state);
        }
        return true;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        if (player != null && player.f_20911_) {
            return InteractionResult.FAIL;
        }
        if (!level.f_46443_ && player != null) {
            ItemCooldowns cooldowns = player.m_36335_();
            BlockState clickedBlockState = level.m_8055_(pos);
            if (!cooldowns.m_41519_(itemStack.m_41720_()) && this.isBreakablePlant(clickedBlockState)) {
                player.m_21011_(hand, true);
                this.breakBlocksInArea(level, pos, player, itemStack);
                itemStack.m_41622_(1, (LivingEntity)player, e -> e.m_21190_(player.m_7655_()));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.generateSweepEffect(serverLevel, player);
                }
                this.applyPlantBreakCooldown(player, hand);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null || entity.m_9236_().m_5776_()) {
            return false;
        }
        boolean isCritical = sourceentity instanceof Player && ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f));
        boolean isFullyCharged = sourceentity instanceof Player && ((Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (isFullyCharged && sourceentity instanceof Player) {
            if (level.f_46441_.m_188501_() < 0.4f) {
                BreakingHandler.damageHeldItem(entity, 4);
            }
            if (level.f_46441_.m_188501_() < 0.8f) {
                BreakingHandler.damageArmorPieces(entity, 2, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
            }
        }
        return retval;
    }

    private void breakBlocksInArea(Level level, BlockPos centerPos, Player player, ItemStack itemStack) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos targetPos = centerPos.m_7918_(dx, 0, dz);
                BlockState blockState = level.m_8055_(targetPos);
                if (!this.isBreakablePlant(blockState)) continue;
                level.m_46953_(targetPos, true, (Entity)player);
            }
        }
    }

    private void generateSweepEffect(ServerLevel serverLevel, Player player) {
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)player.m_20192_() * 0.5;
        double z = player.m_20189_();
        Vec3 lookDirection = player.m_20154_();
        double offsetX = lookDirection.f_82479_ * 1.5;
        double offsetY = 0.0;
        double offsetZ = lookDirection.f_82481_ * 1.5;
        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, x + offsetX, y + offsetY, z + offsetZ, 1, 0.1, 0.1, 0.1, 0.0);
        serverLevel.m_6263_(null, x + offsetX, y + offsetY, z + offsetZ, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void applyPlantBreakCooldown(Player player, InteractionHand hand) {
        ItemCooldowns cooldowns = player.m_36335_();
        ItemStack usedStack = player.m_21120_(hand);
        if (usedStack.m_41720_() instanceof MacheteItem) {
            cooldowns.m_41524_(usedStack.m_41720_(), 10);
        }
    }

    private boolean isBreakablePlant(BlockState blockState) {
        Block block = blockState.m_60734_();
        return block instanceof TallGrassBlock || block == Blocks.f_50692_ || block == Blocks.f_50451_ || block instanceof VineBlock || block instanceof LeavesBlock || block instanceof CocoaBlock || block instanceof PumpkinBlock || block instanceof MelonBlock || block instanceof SugarCaneBlock || block instanceof DoublePlantBlock || block instanceof CactusBlock || block instanceof NetherWartBlock || block instanceof RootsBlock || block instanceof AzaleaBlock || block == BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("jaams_shinerite", "shinerite_roots")) || block instanceof BushBlock && !(block instanceof CropBlock) && !(block instanceof FlowerBlock);
    }
}

