/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.Arrays;
import java.util.List;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.handler.mechanics.DisablerHandler;
import net.jaams.jaams_weaponry.handler.mechanics.ItemSwitchHandler;
import net.jaams.jaams_weaponry.handler.mechanics.SweepAttackHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class SawCleaverItem
extends SwordItem {
    public static final double SWEEP_RANGE = 2.0;
    public static final float BASE_DAMAGE_PERCENT = 0.6f;
    public static final int WEAPON_DAMAGE_PENALTY = 1;
    public static final boolean DAMAGE_BY_ENEMY_COUNT = true;
    public static final int NON_SHIELD_DISABLE_TICKS = 60;
    public static final int DISABLABLE_ITEM_DISABLE_TICKS = 100;

    public SawCleaverItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.SWORD_DIG);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6047_()) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            if (itemId == null || !itemId.m_135827_().equals("jaams_weaponry")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String path = itemId.m_135815_();
            if (path.endsWith("_unfolded")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String targetPath = path + "_unfolded";
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", targetPath);
            Item targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            if (targetItem == ItemStack.f_41583_.m_41720_()) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            List<ResourceLocation> noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:saw_cleavers"), new ResourceLocation("jaams_weaponry:saw_cleavers_unfolded"));
            String soundPath = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            ItemSwitchHandler.switchItem((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack.m_41720_(), targetItem, 30, 30, soundPath, null, noCooldownTags);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isCritical;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean isFullyCharged = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf((float)sourceentity.m_21133_(Attributes.f_22281_))).floatValue();
        if (isFullyCharged) {
            this.applyAttackEffects(itemstack, entity, sourceentity, baseDamage, isCritical, isFullyCharged);
        }
        return retval;
    }

    public void applyAttackEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical, boolean isFullyCharged) {
        float entityHealth = entity.m_21223_();
        if (isFullyCharged) {
            this.applyItemDisable(entity);
            if (sourceentity instanceof Player) {
                Player player = (Player)sourceentity;
                this.performSweepAttackWithDisable(itemstack, entity, player);
            }
        }
    }

    private void performSweepAttackWithDisable(ItemStack itemstack, LivingEntity entity, Player player) {
        SweepAttackHandler.performSweepAttack(itemstack, entity, (LivingEntity)player, 2.0f, 0.6f, 1, true, SoundEvents.f_12317_, (ParticleOptions)ParticleTypes.f_123766_, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        Level level = entity.m_9236_();
        AABB sweepArea = new AABB(entity.m_20182_().m_82520_(-2.0, -2.0, -2.0), entity.m_20182_().m_82520_(2.0, 2.0, 2.0));
        List nearbyEnemies = level.m_6443_(LivingEntity.class, sweepArea, nearby -> SweepAttackHandler.isValidSweepTarget(nearby, entity, (LivingEntity)player, player.m_20154_()));
        for (LivingEntity nearby2 : nearbyEnemies) {
            this.applyItemDisable(nearby2);
        }
    }

    public void applyItemDisable(LivingEntity entity) {
        if (entity.m_6117_()) {
            ItemStack activeItem = entity.m_21211_();
            if (!activeItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(activeItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, 100);
                } else if (!(activeItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, 60);
                }
            }
        } else {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (!mainHandItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(mainHandItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, 100);
                } else if (!(mainHandItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, 60);
                }
            } else if (!offHandItem.m_41619_()) {
                if (DisablerHandler.isDisablableItem(offHandItem)) {
                    DisablerHandler.disableShieldOrWeapon(entity, 100);
                } else if (!(offHandItem.m_41720_() instanceof ShieldItem)) {
                    DisablerHandler.disableActiveItem(entity, 60);
                }
            }
        }
    }
}

