/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.Arrays;
import java.util.List;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.handler.mechanics.ItemSwitchHandler;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class SawCleaverUnfoldedItem
extends SwordItem {
    public static final float HELD_ITEM_DAMAGE_CHANCE = 0.6f;
    public static final int HELD_ITEM_DAMAGE_AMOUNT = 6;
    private static final float DISTANCE_BONUS_PER_BLOCK = 0.05f;
    private static final float CRITICAL_BONUS_MULTIPLIER = 2.0f;
    private static final float MAX_BONUS_BLOCKS = 6.0f;
    private static final float MIN_DISTANCE_BLOCKS = 2.0f;
    private static final float DISTANCE_DURABILITY_COST_PER_BLOCK = 0.5f;
    private static final int BONUS_DURABILITY_COST = 1;

    public SawCleaverUnfoldedItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6047_()) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
            if (itemId == null || !itemId.m_135827_().equals("jaams_weaponry")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String path = itemId.m_135815_();
            if (!path.endsWith("_unfolded")) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            String targetPath = path.substring(0, path.length() - "_unfolded".length());
            ResourceLocation targetItemId = new ResourceLocation("jaams_weaponry", targetPath);
            Item targetItem = (Item)BuiltInRegistries.f_257033_.m_7745_(targetItemId);
            if (targetItem == ItemStack.f_41583_.m_41720_()) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            List<ResourceLocation> noCooldownTags = Arrays.asList(new ResourceLocation("jaams_weaponry:saw_cleavers"), new ResourceLocation("jaams_weaponry:saw_cleavers_unfolded"));
            String soundPath = path.contains("wooden") || path.contains("stone") ? "jaams_weaponry:switch_alt" : "jaams_weaponry:switch";
            ItemSwitchHandler.switchItem((LevelAccessor)world, player.m_20185_(), player.m_20186_(), player.m_20189_(), (Entity)player, itemStack.m_41720_(), targetItem, 30, 30, soundPath, null, noCooldownTags);
            return InteractionResultHolder.m_19096_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isCritical;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean isFullyCharged = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf((float)sourceentity.m_21133_(Attributes.f_22281_))).floatValue();
        if (isFullyCharged) {
            this.applyAttackEffects(itemstack, entity, sourceentity, baseDamage, isCritical);
        }
        return retval;
    }

    public void applyAttackEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical) {
        this.applyDamageBonuses(itemstack, entity, sourceentity, baseDamage, isCritical);
        if (sourceentity.m_9236_().f_46441_.m_188501_() < 0.6f) {
            ItemStack mainHandItem = entity.m_21205_();
            ItemStack offHandItem = entity.m_21206_();
            if (!mainHandItem.m_41619_()) {
                mainHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (!offHandItem.m_41619_()) {
                offHandItem.m_41622_(6, entity, e -> e.m_21166_(EquipmentSlot.OFFHAND));
            }
        }
    }

    public void applyDamageBonuses(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical) {
        float bonusDamage = ModUtils.calculateDistanceBonus(sourceentity, entity, isCritical, 6.0f, 2.0f, 0.05f, 2.0f);
        if (bonusDamage > 0.0f) {
            ModUtils.applyBonusDamage(sourceentity, entity, itemstack, bonusDamage * baseDamage);
            float totalBlocks = (float)Math.min(Math.sqrt(Math.pow(sourceentity.m_20185_() - entity.m_20185_(), 2.0) + Math.pow(sourceentity.m_20189_() - entity.m_20189_(), 2.0)) + Math.abs(sourceentity.m_20188_() - entity.m_20188_()), 6.0);
            int distanceDurabilityCost = (int)Math.ceil(totalBlocks * 0.5f);
            if (sourceentity instanceof Player) {
                itemstack.m_41622_(1 + distanceDurabilityCost, sourceentity, p -> p.m_21190_(p.m_7655_()));
            }
        }
    }
}

