/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.jaams.jaams_weaponry.handler.mechanics.DecapitationHandler;
import net.jaams.jaams_weaponry.handler.mechanics.PullTowardsHandler;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;

public class ScytheItem
extends SwordItem {
    public static final int TILL_AND_HARVEST_RANGE = 1;
    public static final int HARVEST_BLOCK_COUNT = 9;
    public static final int DURABILITY_COST_PER_BLOCK = 1;
    public static final boolean DURABILITY_PER_BLOCK = true;
    public static final double PLAYER_HEAD_DROP_CHANCE = 0.6;
    public static final double ZOMBIE_HEAD_DROP_CHANCE = 0.2;
    public static final double SKELETON_HEAD_DROP_CHANCE = 0.2;
    public static final double WITHER_SKELETON_HEAD_DROP_CHANCE = 0.5;
    public static final double CREEPER_HEAD_DROP_CHANCE = 0.3;
    public static final double ENDERMAN_HEAD_DROP_CHANCE = 0.2;
    public static final double MIME_HEAD_DROP_CHANCE = 0.2;
    public static final double PIGLIN_HEAD_DROP_CHANCE = 0.2;
    public static final double CRITICAL_DECAPITATION_CHANCE = 0.3;
    public static final float BASE_PULL_STRENGTH = 1.8f;
    public static final float MAX_PULL_DISTANCE = 8.0f;
    public static final double MAX_PULL_SPEED = 0.6;
    public static final float ATTACK_STRENGTH_PULL_MODIFIER = 0.4f;
    public static final double BASE_MOVEMENT_SPEED = 0.1;
    public static final float MAX_VERTICAL_PULL = 0.4f;
    public static final float VERTICAL_PULL_DAMPENING = 0.3f;
    public static final float PULL_DISTANCE_SCALING = 0.75f;
    public static final int DURABILITY_COST_PULL = 0;

    public ScytheItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction.equals(ToolActions.HOE_DIG) || toolAction.equals(ToolActions.SWORD_DIG) || toolAction.equals(ToolActions.SWORD_SWEEP);
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return player.m_7500_() ? state.m_60734_() instanceof CropBlock : true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack itemstack = context.m_43722_();
        InteractionHand hand = context.m_43724_();
        if (player != null && ModUtils.isEntityInBattleMode((Entity)player)) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && player != null) {
            CropBlock crop;
            BlockState clickedBlockState = level.m_8055_(pos);
            if (this.isTillable(clickedBlockState)) {
                player.m_21011_(hand, true);
                this.tillLandInArea((ServerLevel)level, pos, player, itemstack);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            Block block = clickedBlockState.m_60734_();
            if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(clickedBlockState)) {
                player.m_21011_(hand, true);
                this.harvestCropsInArea((ServerLevel)level, pos, player, itemstack);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.FAIL;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        Player player;
        Player player2;
        if (itemstack == null || entity == null || sourceentity == null) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean isCritical = sourceentity instanceof Player && (ModUtils.isCritical(player2 = (Player)sourceentity, (Entity)entity, player2.m_36403_(0.5f)) || sourceentity.m_21256_() > 0 || sourceentity.m_20142_());
        boolean isFullyCharged = sourceentity instanceof Player && (player = (Player)sourceentity).m_36403_(0.5f) >= 1.0f;
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Player player3;
            if (entity.m_21223_() <= 0.0f) {
                DecapitationHandler.handleDecapitation(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity, sourceentity, 0.6, 0.2, 0.2, 0.5, 0.3, 0.2, 0.2, 0.2, 0.3);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    int experience = mob.m_213860_();
                    level.m_7967_((Entity)new ExperienceOrb(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), experience * 3));
                }
            }
            if (sourceentity instanceof Player && !(player3 = (Player)sourceentity).m_6047_()) {
                float attackStrength = player3.m_36403_(0.5f);
                PullTowardsHandler.pullEnemyTowardsPlayer(entity, sourceentity, attackStrength, itemstack, 1.8f, 8.0f, 0.6, 0.4f, 0.1, 0.4f, 0.3f, 0.75f, 0);
            }
        }
        return retval;
    }

    private void tillLandInArea(ServerLevel level, BlockPos centerPos, Player player, ItemStack tool) {
        int affectedBlocks = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos abovePos;
                BlockPos targetPos = centerPos.m_7918_(dx, 0, dz);
                BlockState targetState = level.m_8055_(targetPos);
                if (!this.isTillable(targetState) || !level.m_46859_(abovePos = targetPos.m_7494_())) continue;
                BlockState farmland = Blocks.f_50093_.m_49966_();
                level.m_7731_(targetPos, farmland, 3);
                ++affectedBlocks;
            }
        }
        if (affectedBlocks > 0) {
            level.m_5594_(null, centerPos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            tool.m_41622_(affectedBlocks * 1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    private void harvestCropsInArea(ServerLevel level, BlockPos centerPos, Player player, ItemStack tool) {
        int affectedBlocks = 0;
        Inventory inventory = player.m_150109_();
        ArrayList<ItemStack> allDrops = new ArrayList<ItemStack>();
        for (int dx = -1; dx <= 1 && affectedBlocks < 9; ++dx) {
            for (int dz = -1; dz <= 1 && affectedBlocks < 9; ++dz) {
                CropBlock crop;
                BlockPos targetPos = centerPos.m_7918_(dx, 0, dz);
                BlockState blockState = level.m_8055_(targetPos);
                Block block = blockState.m_60734_();
                if (!(block instanceof CropBlock) || !(crop = (CropBlock)block).m_52307_(blockState)) continue;
                List drops = Block.m_49869_((BlockState)blockState, (ServerLevel)level, (BlockPos)targetPos, null);
                for (ItemStack drop : drops) {
                    if (drop.m_41619_()) continue;
                    allDrops.add(drop.m_41777_());
                }
                level.m_46961_(targetPos, false);
                level.m_7731_(targetPos, crop.m_52289_(0), 3);
                level.m_5594_(null, targetPos, SoundEvents.f_11838_, SoundSource.BLOCKS, 1.0f, 1.0f);
                ++affectedBlocks;
            }
        }
        HashMap<Item, ItemStack> consolidatedDrops = new HashMap<Item, ItemStack>();
        for (ItemStack drop : allDrops) {
            Item item = drop.m_41720_();
            consolidatedDrops.compute(item, (key, existing) -> {
                if (existing == null) {
                    return drop.m_41777_();
                }
                existing.m_41769_(drop.m_41613_());
                return existing;
            });
        }
        block4: for (ItemStack drop : consolidatedDrops.values()) {
            int remaining = drop.m_41613_();
            Item item = drop.m_41720_();
            for (int i = 0; i < inventory.m_6643_() && remaining > 0; ++i) {
                int spaceLeft;
                ItemStack slotStack = inventory.m_8020_(i);
                if (slotStack.m_41619_() || slotStack.m_41720_() != item || (spaceLeft = slotStack.m_41741_() - slotStack.m_41613_()) <= 0) continue;
                int amountToAdd = Math.min(remaining, spaceLeft);
                slotStack.m_41769_(amountToAdd);
                remaining -= amountToAdd;
                inventory.m_6596_();
            }
            while (remaining > 0) {
                int amountToAdd = Math.min(remaining, drop.m_41741_());
                ItemStack newStack = new ItemStack((ItemLike)item, amountToAdd);
                int emptySlot = -1;
                for (int i = 0; i < inventory.m_6643_(); ++i) {
                    if (!inventory.m_8020_(i).m_41619_()) continue;
                    emptySlot = i;
                    break;
                }
                if (emptySlot != -1) {
                    inventory.m_6836_(emptySlot, newStack);
                    remaining -= amountToAdd;
                    inventory.m_6596_();
                    continue;
                }
                ItemStack remainingStack = new ItemStack((ItemLike)item, remaining);
                level.m_7967_((Entity)new ItemEntity((Level)level, (double)centerPos.m_123341_() + 0.5, (double)centerPos.m_123342_() + 0.5, (double)centerPos.m_123343_() + 0.5, remainingStack));
                continue block4;
            }
        }
        if (affectedBlocks > 0) {
            this.generateSweepEffect(level, player);
            int durabilityCost = affectedBlocks * 1;
            tool.m_41622_(durabilityCost, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
        }
    }

    private void generateSweepEffect(ServerLevel serverLevel, Player player) {
        double x = player.m_20185_();
        double y = player.m_20186_() + (double)player.m_20192_() * 0.5;
        double z = player.m_20189_();
        Vec3 lookDirection = player.m_20154_();
        double offsetX = lookDirection.f_82479_ * 1.5;
        double offsetY = (double)serverLevel.f_46441_.m_188501_() * 0.5 - 0.25;
        double offsetZ = lookDirection.f_82481_ * 2.5;
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float size = 1.0f;
        serverLevel.m_8767_((ParticleOptions)new CustomSweepParticleData(r, g, b, size), x + offsetX, y + offsetY, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        serverLevel.m_6263_(null, x + offsetX, y + offsetY, z + offsetZ, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private boolean isTillable(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50493_) || blockState.m_60713_(Blocks.f_50440_) || blockState.m_60713_(Blocks.f_50546_);
    }
}

