/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.configuration.JaamsWeaponryCommonConfiguration;
import net.jaams.jaams_weaponry.entity.SlingshotProjectileEntity;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModSounds;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class SlingshotItem
extends Item {
    public static final int MAX_DRAW_DURATION = 20;
    public static final float MIN_PROJECTILE_SPEED = 0.5f;
    public static final float MAX_PROJECTILE_SPEED = 2.5f;

    public SlingshotItem(Item.Properties properties) {
        super(properties);
    }

    public abstract boolean isAmmoItem(ItemStack var1);

    public abstract SlingshotProjectileEntity createProjectile(Level var1, LivingEntity var2);

    public abstract float getProjectileDamage(ItemStack var1);

    public abstract ItemStack getDefaultCreativeAmmo();

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44988_ || enchantment == Enchantments.f_44989_ || enchantment == Enchantments.f_44990_ || enchantment == Enchantments.f_44961_ || enchantment == Enchantments.f_44959_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack slingshot = player.m_21120_(hand);
        ItemStack ammo = this.findAmmo(player, hand);
        if (ammo.m_41619_() && !player.m_150110_().f_35937_) {
            return InteractionResultHolder.m_19100_((Object)slingshot);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)slingshot);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseTicks) {
        if (!level.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            int useDuration = this.m_8105_(stack) - remainingUseTicks;
            if (useDuration == 5) {
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)JaamsWeaponryModSounds.SLINGSHOT_LOAD.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!level.m_5776_()) {
                int itemCount;
                InteractionHand hand = player.m_7655_();
                ItemStack ammo = this.findAmmo(player, hand);
                boolean isCreative = player.m_150110_().f_35937_;
                if (ammo.m_41619_() && isCreative) {
                    ammo = this.getDefaultCreativeAmmo();
                }
                if (ammo.m_41619_()) {
                    return;
                }
                int remainingDuration = this.m_8105_(stack) - timeLeft;
                if ((remainingDuration = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)remainingDuration, (!ammo.m_41619_() ? 1 : 0) != 0)) < 5) {
                    return;
                }
                float power = SlingshotItem.getPowerForTime(remainingDuration);
                if (power < 0.1f) {
                    return;
                }
                boolean hasInfinity = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                boolean hasMultishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack) > 0;
                int requiredItems = 1;
                int n = itemCount = isCreative || hasInfinity ? requiredItems : ammo.m_41613_();
                if (itemCount >= requiredItems) {
                    int projectileCount = hasMultishot ? 3 : 1;
                    float[] shotPitches = SlingshotItem.generateShotPitches(level.m_213780_(), projectileCount);
                    for (int i = 0; i < projectileCount; ++i) {
                        int pierceLevel;
                        int powerLevel;
                        int slotIndex;
                        SlingshotProjectileEntity projectile = this.createProjectile(level, (LivingEntity)player);
                        int n2 = slotIndex = hand == InteractionHand.MAIN_HAND ? player.m_150109_().f_35977_ : 40;
                        if (ammo != player.m_21120_(InteractionHand.MAIN_HAND) && ammo != player.m_21120_(InteractionHand.OFF_HAND)) {
                            slotIndex = player.m_150109_().m_36030_(ammo);
                        }
                        projectile.setOriginalSlotIndex(slotIndex);
                        projectile.setChargedForCrit(power >= 1.0f);
                        if (ModUtils.isProjectileCritical(player, power)) {
                            projectile.setCritical(true);
                        }
                        projectile.setBlockItem(ammo.m_41777_());
                        float damage = this.getProjectileDamage(ammo);
                        if (power >= 1.0f) {
                            damage += 2.0f;
                        }
                        if ((powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
                            damage += (float)powerLevel * 0.5f + 0.5f;
                        }
                        projectile.setBlockDamage(damage);
                        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
                        float knockback = 0.5f;
                        if (punchLevel > 0) {
                            knockback += (float)punchLevel * 0.3f;
                        }
                        projectile.setBlockKnockback(knockback);
                        int flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack);
                        if (flameLevel > 0) {
                            projectile.m_20254_(60);
                        }
                        if ((pierceLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)stack)) > 0) {
                            projectile.setPiercingLevel(pierceLevel);
                        }
                        if (hasMultishot) {
                            projectile.getPersistentData().m_128379_("CanPlaceBlock", isCreative || i == 0);
                            AbstractArrow.Pickup pickup = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : (projectile.f_36705_ = i == 0 ? AbstractArrow.Pickup.ALLOWED : AbstractArrow.Pickup.DISALLOWED);
                            if (!isCreative && i != 0) {
                                projectile.getPersistentData().m_128379_("BreakOnBlockHit", true);
                            }
                            float spreadAngle = 10.0f;
                            float rotation = i == 0 ? 0.0f : (i == 1 ? -spreadAngle : spreadAngle);
                            Vec3 upVector = player.m_20289_(1.0f);
                            Quaternionf rotationQuaternion = new Quaternionf().setAngleAxis((double)(rotation * (float)Math.PI / 180.0f), upVector.f_82479_, upVector.f_82480_, upVector.f_82481_);
                            Vec3 viewVector = player.m_20252_(1.0f);
                            Vector3f rotatedVector = viewVector.m_252839_().rotate((Quaternionfc)rotationQuaternion);
                            if (i == 0) {
                                float forwardOffset = 1.0f;
                                Vec3 offset = viewVector.m_82490_((double)forwardOffset);
                                projectile.m_6034_(player.m_20185_() + offset.f_82479_, player.m_20188_() + offset.f_82480_, player.m_20189_() + offset.f_82481_);
                            }
                            projectile.m_6686_(rotatedVector.x(), rotatedVector.y(), rotatedVector.z(), this.calculateProjectileSpeed(power), 1.0f);
                        } else {
                            projectile.getPersistentData().m_128379_("CanPlaceBlock", true);
                            projectile.f_36705_ = isCreative ? AbstractArrow.Pickup.CREATIVE_ONLY : AbstractArrow.Pickup.ALLOWED;
                            projectile.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, this.calculateProjectileSpeed(power), 1.0f);
                        }
                        level.m_7967_((Entity)projectile);
                        level.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)JaamsWeaponryModSounds.SLINGSHOT_SHOOT.get(), SoundSource.PLAYERS, 1.0f, shotPitches[i]);
                    }
                    if (!isCreative && !hasInfinity) {
                        ammo.m_41774_(1);
                        if (ammo.m_41619_()) {
                            int slot = player.m_150109_().m_36030_(ammo);
                            if (slot >= 0) {
                                player.m_150109_().m_6836_(slot, ItemStack.f_41583_);
                            } else if (ammo == player.m_21120_(InteractionHand.MAIN_HAND)) {
                                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                            } else if (ammo == player.m_21120_(InteractionHand.OFF_HAND)) {
                                player.m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                            }
                        }
                    }
                    if (!isCreative) {
                        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
                player.m_21011_(hand, true);
            }
        }
    }

    public static float getPowerForTime(int duration) {
        float f = (float)duration / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.0f);
    }

    protected float calculateProjectileSpeed(float power) {
        float speedRange = 2.0f;
        float scaledPower = power * power;
        return 0.5f + speedRange * scaledPower;
    }

    public static float[] generateShotPitches(RandomSource random, int projectileCount) {
        float[] pitches = new float[Math.max(projectileCount, 1)];
        for (int i = 0; i < pitches.length; ++i) {
            boolean flag = random.m_188499_();
            pitches[i] = 1.0f / (random.m_188501_() * 0.5f + 1.8f) + (flag ? 0.63f : 0.43f);
        }
        return pitches;
    }

    protected ItemStack findAmmo(Player player, InteractionHand hand) {
        InteractionHand otherHand = hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherHandItem = player.m_21120_(otherHand);
        if (this.isAmmoItem(otherHandItem)) {
            return otherHandItem;
        }
        ItemStack mainHandItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand != InteractionHand.MAIN_HAND && this.isAmmoItem(mainHandItem)) {
            return mainHandItem;
        }
        if (((Boolean)JaamsWeaponryCommonConfiguration.SLINGSHOTAMMOFROMINVENTORY.get()).booleanValue()) {
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                ItemStack stack = inventory.m_8020_(i);
                if (!this.isAmmoItem(stack)) continue;
                return stack;
            }
        }
        return ItemStack.f_41583_;
    }
}

