/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.particles.CustomSweepParticleData;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class TwinbladeItem
extends SwordItem {
    public static int INVULNERABLE_TIME = 0;
    public static float INVULNERABLE_CHANCE = 0.5f;
    private static final float SECONDARY_DAMAGE_MODIFIER = 0.5f;
    private static final float TERTIARY_DAMAGE_MODIFIER = 0.3f;
    private static final float TERTIARY_ATTACK_CHANCE = 0.3f;
    private static final int SECONDARY_ATTACK_DELAY = 10;
    private static final int TERTIARY_ATTACK_DELAY = 10;
    private static final int DURABILITY_COST = 2;
    private static final String NBT_HITS = "TwinbladeHits";

    public TwinbladeItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isFullyCharged;
        boolean isCritical;
        if (entity == null || sourceentity == null || entity.m_9236_().m_5776_()) {
            return false;
        }
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean bl2 = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : (isFullyCharged = true);
        if (isCritical) {
            this.scheduleSecondaryAttack(itemstack, entity, sourceentity, true);
        } else {
            this.updateHitCounterAndCheckSecondaryAttack(itemstack, entity, sourceentity);
        }
        this.applyInvulnerabilityEffects(itemstack, entity, sourceentity, isCritical, isFullyCharged);
        return retval;
    }

    public void applyInvulnerabilityEffects(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, boolean isCritical, boolean isFullyCharged) {
        Level level = entity.m_9236_();
        if (isFullyCharged) {
            entity.f_19802_ = INVULNERABLE_TIME;
        } else if (level.f_46441_.m_188501_() < INVULNERABLE_CHANCE) {
            entity.f_19802_ = INVULNERABLE_TIME;
        }
        if (isCritical) {
            entity.f_19802_ = INVULNERABLE_TIME;
        }
    }

    private void updateHitCounterAndCheckSecondaryAttack(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        CompoundTag nbt = itemstack.m_41784_();
        int hits = nbt.m_128451_(NBT_HITS) + 1;
        if (hits >= 2) {
            hits = 0;
            this.scheduleSecondaryAttack(itemstack, entity, sourceentity, false);
        }
        nbt.m_128405_(NBT_HITS, hits);
        itemstack.m_41751_(nbt);
    }

    public void scheduleSecondaryAttack(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, boolean isCritical) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        JaamsWeaponryMod.queueServerWork(10, () -> {
            Player player;
            if (!entity.m_6084_() || !sourceentity.m_6084_() || sourceentity instanceof Player && ModUtils.isAlliedEntity(player = (Player)sourceentity, (Entity)entity)) {
                return;
            }
            float damageModifier = isCritical ? (level.f_46441_.m_188501_() < 0.5f ? 1.0f : 0.5f) : 0.5f;
            float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf(this.m_43299_())).floatValue();
            float finalDamage = baseDamage * damageModifier;
            DamageSource damageSource = sourceentity instanceof Player ? sourceentity.m_269291_().m_269075_((Player)sourceentity) : sourceentity.m_269291_().m_269333_(sourceentity);
            entity.m_6469_(damageSource, finalDamage);
            TwinbladeItem.applyWeaponEnchantmentEffects(entity, sourceentity, itemstack);
            if (itemstack != null) {
                itemstack.m_41622_(2, sourceentity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            this.spawnSweepParticles(serverLevel, entity, 1.0f);
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, sourceentity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f);
            if (!isCritical && level.f_46441_.m_188501_() < 0.3f) {
                this.scheduleTertiaryAttack(itemstack, entity, sourceentity);
            }
        });
    }

    public void scheduleTertiaryAttack(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        JaamsWeaponryMod.queueServerWork(10, () -> {
            Player player;
            if (!entity.m_6084_() || !sourceentity.m_6084_() || sourceentity instanceof Player && ModUtils.isAlliedEntity(player = (Player)sourceentity, (Entity)entity)) {
                return;
            }
            float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf(this.m_43299_())).floatValue();
            float finalDamage = baseDamage * 0.3f;
            DamageSource damageSource = sourceentity instanceof Player ? sourceentity.m_269291_().m_269075_((Player)sourceentity) : sourceentity.m_269291_().m_269333_(sourceentity);
            entity.m_6469_(damageSource, finalDamage);
            TwinbladeItem.applyWeaponEnchantmentEffects(entity, sourceentity, itemstack);
            if (itemstack != null) {
                itemstack.m_41622_(2, sourceentity, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
            this.spawnSweepParticles(serverLevel, entity, 0.7f);
            serverLevel.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12317_, sourceentity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE, 1.0f, 1.0f);
        });
    }

    private static void applyWeaponEnchantmentEffects(LivingEntity entity, LivingEntity sourceentity, ItemStack weaponItem) {
        int knockbackLevel;
        int baneOfArthropodsLevel;
        int fireAspectLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)weaponItem);
        if (fireAspectLevel > 0) {
            entity.m_20254_(fireAspectLevel * 4);
        }
        if ((baneOfArthropodsLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44979_, (ItemStack)weaponItem)) > 0 && entity.m_6336_() == MobType.f_21642_) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, baneOfArthropodsLevel * 50, 3));
        }
        if ((knockbackLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)weaponItem)) > 0) {
            double motionZ;
            double knockbackStrength = (double)knockbackLevel * 0.5;
            double motionX = entity.m_20185_() - sourceentity.m_20185_();
            double distance = Math.sqrt(motionX * motionX + (motionZ = entity.m_20189_() - sourceentity.m_20189_()) * motionZ);
            if (distance > 0.0) {
                entity.m_5997_(motionX / distance * knockbackStrength, 0.1, motionZ / distance * knockbackStrength);
            }
        }
        EnchantmentHelper.m_44823_((LivingEntity)entity, (Entity)sourceentity);
        EnchantmentHelper.m_44896_((LivingEntity)sourceentity, (Entity)entity);
    }

    private void spawnSweepParticles(ServerLevel serverLevel, LivingEntity entity, float size) {
        if (entity == null || serverLevel == null) {
            return;
        }
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        double centerY = entity.m_20186_() + (double)entity.m_20206_() / 2.0;
        float rand = serverLevel.f_46441_.m_188501_();
        double yOffset = rand < 0.2f ? (double)serverLevel.f_46441_.m_188501_() * -0.3 : (rand < 0.4f ? (double)serverLevel.f_46441_.m_188501_() * 1.5 : (double)serverLevel.f_46441_.m_188501_() * 0.7);
        double particleY = centerY + yOffset;
        serverLevel.m_8767_((ParticleOptions)new CustomSweepParticleData(r, g, b, size), entity.m_20185_(), particleY, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static String getNbtHitsKey() {
        return NBT_HITS;
    }
}

