/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.weapons;

import net.jaams.jaams_weaponry.capability.amount.AmountProvider;
import net.jaams.jaams_weaponry.util.ModUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ZweihanderItem
extends SwordItem {
    private static final float DISTANCE_BONUS_PER_BLOCK = 0.08f;
    private static final float CRITICAL_BONUS_MULTIPLIER = 1.8f;
    private static final float MAX_BONUS_BLOCKS = 8.0f;
    private static final float MIN_DISTANCE_BLOCKS = 1.5f;
    private static final float DISTANCE_DURABILITY_COST_PER_BLOCK = 0.5f;
    private static final int BONUS_DURABILITY_COST = 1;

    public ZweihanderItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public int m_8105_(ItemStack itemstack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemstack) {
        return UseAnim.BLOCK;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player entity, InteractionHand hand) {
        ItemStack itemStack = entity.m_21120_(hand);
        if (!ModUtils.isEntityInBattleMode((Entity)entity)) {
            entity.m_6672_(hand);
            return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
        }
        return new InteractionResultHolder(InteractionResult.CONSUME, (Object)entity.m_21120_(hand));
    }

    public boolean m_7579_(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean isCritical;
        boolean retval = super.m_7579_(itemstack, entity, sourceentity);
        if (entity == null || sourceentity == null) {
            return false;
        }
        boolean isPlayer = sourceentity instanceof Player;
        boolean bl = isPlayer ? ModUtils.isCritical((Player)sourceentity, (Entity)entity, ((Player)sourceentity).m_36403_(0.5f)) : (isCritical = sourceentity.m_9236_().f_46441_.m_188501_() < 0.05f);
        boolean isFullyCharged = isPlayer ? ((Player)sourceentity).m_36403_(0.5f) >= 1.0f : true;
        float baseDamage = sourceentity.getCapability(AmountProvider.AMOUNT).map(amount -> Float.valueOf(amount.getDamage())).orElse(Float.valueOf((float)sourceentity.m_21133_(Attributes.f_22281_))).floatValue();
        if (isFullyCharged) {
            this.applyDamageBonuses(itemstack, entity, sourceentity, baseDamage, isCritical);
        }
        return retval;
    }

    public void applyDamageBonuses(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity, float baseDamage, boolean isCritical) {
        float bonusDamage = ModUtils.calculateDistanceBonus(sourceentity, entity, isCritical, 8.0f, 1.5f, 0.08f, 1.8f);
        if (bonusDamage > 0.0f) {
            ModUtils.applyBonusDamage(sourceentity, entity, itemstack, bonusDamage * baseDamage);
            float totalBlocks = (float)Math.min(Math.sqrt(Math.pow(sourceentity.m_20185_() - entity.m_20185_(), 2.0) + Math.pow(sourceentity.m_20189_() - entity.m_20189_(), 2.0)) + Math.abs(sourceentity.m_20188_() - entity.m_20188_()), 8.0);
            int distanceDurabilityCost = (int)Math.ceil(totalBlocks * 0.5f);
            itemstack.m_41622_(1 + distanceDurabilityCost, sourceentity, p -> p.m_21190_(p.m_7655_()));
        }
    }
}

