/*
 * Decompiled with CFR 0.152.
 */
package net.jaams.jaams_weaponry.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.jaams.jaams_weaponry.JaamsWeaponryMod;
import net.jaams.jaams_weaponry.configuration.JaamsWeaponryClientConfiguration;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModItems;
import net.jaams.jaams_weaponry.init.JaamsWeaponryModMenus;
import net.jaams.jaams_weaponry.network.PistolGUISlotMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class PistolGUIMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.f_39287_;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;
    private ItemStack boundItemStack = ItemStack.f_41583_;
    private byte boundHand;
    private boolean isClosing = false;
    private final Map<Integer, ItemStack> lastKnownStacks = new HashMap<Integer, ItemStack>();

    public PistolGUIMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)JaamsWeaponryModMenus.PISTOL_GUI.get(), id);
        int si;
        this.entity = inv.f_35978_;
        this.world = inv.f_35978_.m_9236_();
        this.internal = new ItemStackHandler(3);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.m_130135_();
            this.x = pos.m_123341_();
            this.y = pos.m_123342_();
            this.z = pos.m_123343_();
            this.access = ContainerLevelAccess.m_39289_((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                ItemStack itemstack;
                this.boundHand = extraData.readByte();
                this.boundItemStack = itemstack = this.boundHand == 0 ? this.entity.m_21205_() : this.entity.m_21206_();
                this.boundItemMatcher = () -> itemstack == (this.boundHand == 0 ? this.entity.m_21205_() : this.entity.m_21206_());
                itemstack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                    this.internal = capability;
                    this.bound = true;
                });
            } else if (extraData.readableBytes() > 1) {
                extraData.readByte();
                this.boundEntity = this.world.m_6815_(extraData.m_130242_());
                if (this.boundEntity != null) {
                    this.boundEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            } else {
                this.boundBlockEntity = this.world.m_7702_(pos);
                if (this.boundBlockEntity != null) {
                    this.boundBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(capability -> {
                        this.internal = capability;
                        this.bound = true;
                    });
                }
            }
        }
        this.customSlots.put(0, this.m_38897_((Slot)new SlotItemHandler(this.internal, 0, 62, 55){
            private final int slot = 0;
            {
                this.slot = 0;
            }

            public void m_6654_() {
                super.m_6654_();
                PistolGUIMenu.this.slotChanged(0, 0, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return JaamsWeaponryModItems.COPPER_MUZZLE.get() == stack.m_41720_();
            }

            public boolean m_8010_(Player playerIn) {
                return !PistolGUIMenu.this.boundItemStack.m_41619_() && (playerIn.m_21205_() == PistolGUIMenu.this.boundItemStack || playerIn.m_21206_() == PistolGUIMenu.this.boundItemStack);
            }
        }));
        this.customSlots.put(1, this.m_38897_((Slot)new SlotItemHandler(this.internal, 1, 80, 55){
            private final int slot = 1;
            {
                this.slot = 1;
            }

            public void m_6654_() {
                super.m_6654_();
                PistolGUIMenu.this.slotChanged(1, 0, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return stack.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("jaams_weaponry:bullets")));
            }

            public boolean m_8010_(Player playerIn) {
                return !PistolGUIMenu.this.boundItemStack.m_41619_() && (playerIn.m_21205_() == PistolGUIMenu.this.boundItemStack || playerIn.m_21206_() == PistolGUIMenu.this.boundItemStack);
            }
        }));
        this.customSlots.put(2, this.m_38897_((Slot)new SlotItemHandler(this.internal, 2, 98, 55){
            private final int slot = 2;
            {
                this.slot = 2;
            }

            public void m_6654_() {
                super.m_6654_();
                PistolGUIMenu.this.slotChanged(2, 0, 0);
            }

            public boolean m_5857_(ItemStack stack) {
                return JaamsWeaponryModItems.COPPER_QUICK_DRAW_MAGAZINE.get() == stack.m_41720_();
            }

            public boolean m_8010_(Player playerIn) {
                return !PistolGUIMenu.this.boundItemStack.m_41619_() && (playerIn.m_21205_() == PistolGUIMenu.this.boundItemStack || playerIn.m_21206_() == PistolGUIMenu.this.boundItemStack);
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
        PistolGUIMenu.playClientSound((LevelAccessor)this.world, this.x, this.y, this.z, new ResourceLocation("jaams_weaponry:gun_system_pistol_open"));
    }

    public boolean m_6875_(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundHand == 0 ? player.m_21205_() == this.boundItemStack : player.m_21206_() == this.boundItemStack;
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.m_58900_().m_60734_());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.m_6084_();
            }
        }
        return false;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (!this.isClosing && !this.boundItemStack.m_41619_() && itemstack1 == this.boundItemStack) {
                this.isClosing = true;
                playerIn.m_6915_();
                return ItemStack.f_41583_;
            }
            if (index < 3) {
                if (!this.m_38903_(itemstack1, 3, this.f_38839_.size(), true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (!this.m_38903_(itemstack1, 0, 3, false)) {
                if (index < 30 ? !this.m_38903_(itemstack1, 30, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 3, 30, false)) {
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void m_6199_(Container inventory) {
        super.m_6199_(inventory);
        if (this.bound && this.boundItemMatcher != null && !(this.boundHand != 0 ? this.entity.m_21206_() == this.boundItemStack : this.entity.m_21205_() == this.boundItemStack)) {
            this.isClosing = true;
            this.entity.m_6915_();
        }
    }

    protected boolean m_38903_(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.m_41753_()) {
            while (!p_38904_.m_41619_() && !(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5857_(itemstack = slot.m_7993_()) && !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.m_41613_() + p_38904_.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), p_38904_.m_41741_()))) {
                        p_38904_.m_41764_(0);
                        itemstack.m_41764_(j);
                        slot.m_5852_(itemstack);
                        flag = true;
                    } else if (itemstack.m_41613_() < maxSize) {
                        p_38904_.m_41774_(maxSize - itemstack.m_41613_());
                        itemstack.m_41764_(maxSize);
                        slot.m_5852_(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.m_41619_()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(p_38904_)) {
                    if (p_38904_.m_41613_() > slot1.m_6641_()) {
                        slot1.m_269060_(p_38904_.m_41620_(slot1.m_6641_()));
                    } else {
                        slot1.m_269060_(p_38904_.m_41620_(p_38904_.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void m_6877_(Player playerIn) {
        block4: {
            super.m_6877_(playerIn);
            PistolGUIMenu.playClientSound((LevelAccessor)this.world, this.x, this.y, this.z, new ResourceLocation("jaams_weaponry:gun_system_pistol_closed"));
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.m_6084_() || serverPlayer.m_9232_()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    playerIn.m_36176_(this.internal.extractItem(j, this.internal.getStackInSlot(j).m_41613_(), false), false);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    playerIn.m_150109_().m_150079_(this.internal.extractItem(i, this.internal.getStackInSlot(i).m_41613_(), false));
                }
            }
        }
    }

    private void slotChanged(int slotid, int ctype, int meta) {
        if (this.world != null && this.world.m_5776_()) {
            ItemStack currentStack = this.internal.getStackInSlot(slotid);
            if (ctype == 0 || !currentStack.equals(this.lastKnownStacks.getOrDefault(slotid, ItemStack.f_41583_))) {
                JaamsWeaponryMod.PACKET_HANDLER.sendToServer((Object)new PistolGUISlotMessage(slotid, this.x, this.y, this.z, ctype, meta));
                PistolGUISlotMessage.handleSlotAction(this.entity, slotid, ctype, meta, this.x, this.y, this.z);
                this.lastKnownStacks.put(slotid, currentStack.m_41777_());
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }

    private static void playClientSound(LevelAccessor world, double x, double y, double z, ResourceLocation sound) {
        if (((Boolean)JaamsWeaponryClientConfiguration.GUNINVSOUNDS.get()).booleanValue() && world.m_5776_()) {
            ((Level)world).m_7785_(x, y, z, (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(sound), SoundSource.PLAYERS, 1.0f, 1.0f, false);
        }
    }
}

