/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.broodmotherswrath.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelBroodMother
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"brood_mothers_wrath", (String)"model_brood_mother"), "main");
    public final ModelPart bone;
    public final ModelPart leg1;
    public final ModelPart leg16;
    public final ModelPart leg3;
    public final ModelPart leg15;
    public final ModelPart leg5;
    public final ModelPart leg14;
    public final ModelPart leg7;
    public final ModelPart leg13;
    public final ModelPart bone2;
    public final ModelPart leg2;
    public final ModelPart leg12;
    public final ModelPart leg4;
    public final ModelPart leg11;
    public final ModelPart leg6;
    public final ModelPart leg10;
    public final ModelPart leg8;
    public final ModelPart leg9;
    public final ModelPart head;
    public final ModelPart headwear;
    public final ModelPart body2;
    public final ModelPart body;
    public final ModelPart neck;
    public final ModelPart jacket;
    public final ModelPart left_arm;
    public final ModelPart left_sleeve;
    public final ModelPart right_arm;
    public final ModelPart right_sleeve;

    public ModelBroodMother(ModelPart root) {
        super(root);
        this.bone = root.getChild("bone");
        this.leg1 = this.bone.getChild("leg1");
        this.leg16 = this.leg1.getChild("leg16");
        this.leg3 = this.bone.getChild("leg3");
        this.leg15 = this.leg3.getChild("leg15");
        this.leg5 = this.bone.getChild("leg5");
        this.leg14 = this.leg5.getChild("leg14");
        this.leg7 = this.bone.getChild("leg7");
        this.leg13 = this.leg7.getChild("leg13");
        this.bone2 = root.getChild("bone2");
        this.leg2 = this.bone2.getChild("leg2");
        this.leg12 = this.leg2.getChild("leg12");
        this.leg4 = this.bone2.getChild("leg4");
        this.leg11 = this.leg4.getChild("leg11");
        this.leg6 = this.bone2.getChild("leg6");
        this.leg10 = this.leg6.getChild("leg10");
        this.leg8 = this.bone2.getChild("leg8");
        this.leg9 = this.leg8.getChild("leg9");
        this.head = root.getChild("head");
        this.headwear = root.getChild("headwear");
        this.body2 = root.getChild("body2");
        this.body = this.body2.getChild("body");
        this.neck = this.body2.getChild("neck");
        this.jacket = root.getChild("jacket");
        this.left_arm = root.getChild("left_arm");
        this.left_sleeve = root.getChild("left_sleeve");
        this.right_arm = root.getChild("right_arm");
        this.right_sleeve = root.getChild("right_sleeve");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bone = partdefinition.addOrReplaceChild("bone", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)18.5f, (float)3.0f));
        PartDefinition leg1 = bone.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(24, 67).addBox(-11.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4597f, (float)0.4176f, (float)0.8845f));
        PartDefinition leg16 = leg1.addOrReplaceChild("leg16", CubeListBuilder.create().texOffs(21, 67).addBox(-14.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg3 = bone.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(24, 67).addBox(-11.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0618f, (float)0.0617f, (float)0.7873f));
        PartDefinition leg15 = leg3.addOrReplaceChild("leg15", CubeListBuilder.create().texOffs(21, 67).addBox(-14.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg5 = bone.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(24, 67).addBox(-11.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)-0.0618f, (float)-0.0617f, (float)0.7873f));
        PartDefinition leg14 = leg5.addOrReplaceChild("leg14", CubeListBuilder.create().texOffs(21, 67).addBox(-14.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg7 = bone.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(24, 67).addBox(-11.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.0f, (float)-0.4597f, (float)-0.4176f, (float)0.8845f));
        PartDefinition leg13 = leg7.addOrReplaceChild("leg13", CubeListBuilder.create().texOffs(21, 67).addBox(-14.0f, 0.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.9659f, (float)1.2588f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition bone2 = partdefinition.addOrReplaceChild("bone2", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)18.5f, (float)3.0f));
        PartDefinition leg2 = bone2.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4597f, (float)-0.4176f, (float)-0.8845f));
        PartDefinition leg12 = leg2.addOrReplaceChild("leg12", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg4 = bone2.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0618f, (float)-0.0617f, (float)-0.7873f));
        PartDefinition leg11 = leg4.addOrReplaceChild("leg11", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg6 = bone2.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-5.0f, (float)-0.0618f, (float)0.0617f, (float)-0.7873f));
        PartDefinition leg10 = leg6.addOrReplaceChild("leg10", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg8 = bone2.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, 0.0f, 0.0f, 12.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-7.0f, (float)-0.4597f, (float)0.4176f, (float)-0.8845f));
        PartDefinition leg9 = leg8.addOrReplaceChild("leg9", CubeListBuilder.create().texOffs(20, 67).addBox(-1.0f, -1.0f, 0.0f, 15.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(2, 3).addBox(-4.0f, -7.0f, -4.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)6.0f, (float)-4.0f));
        PartDefinition headwear = partdefinition.addOrReplaceChild("headwear", CubeListBuilder.create().texOffs(34, 3).addBox(-4.0f, -7.0f, -4.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.5f, (float)6.0f, (float)-4.0f));
        PartDefinition body2 = partdefinition.addOrReplaceChild("body2", CubeListBuilder.create().texOffs(18, 18).addBox(-4.0f, 1.0f, -2.0f, 8.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-4.0f));
        PartDefinition body = body2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(3, 78).addBox(-4.5f, -5.0f, -5.0f, 9.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.5f, (float)13.0f));
        PartDefinition neck = body2.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(7, 83).addBox(-3.5f, -3.0f, -5.0f, 7.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.5f, (float)4.0f));
        PartDefinition jacket = partdefinition.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(18, 35).addBox(-4.0f, 1.0f, -2.0f, 8.0f, 11.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)5.0f, (float)-4.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(34, 51).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)7.0f, (float)-4.0f));
        PartDefinition left_sleeve = partdefinition.addOrReplaceChild("left_sleeve", CubeListBuilder.create().texOffs(52, 51).addBox(-1.0f, -1.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)5.0f, (float)7.0f, (float)-4.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(42, 17).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.1f, (float)7.0f, (float)-4.0f));
        PartDefinition right_sleeve = partdefinition.addOrReplaceChild("right_sleeve", CubeListBuilder.create().texOffs(42, 34).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 11.0f, 3.0f, new CubeDeformation(0.25f)), PartPose.offset((float)-4.1f, (float)7.0f, (float)-4.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)66, (int)99);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg5.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg8.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg6.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg7.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

