/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.broodmotherswrath.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ModelZombieBroodling
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"brood_mothers_wrath", (String)"model_zombie_broodling"), "main");
    public final ModelPart head;
    public final ModelPart neck;
    public final ModelPart body;
    public final ModelPart leg1;
    public final ModelPart leg16;
    public final ModelPart leg2;
    public final ModelPart leg12;
    public final ModelPart leg3;
    public final ModelPart leg15;
    public final ModelPart leg4;
    public final ModelPart leg11;
    public final ModelPart leg5;
    public final ModelPart leg14;
    public final ModelPart leg6;
    public final ModelPart leg10;
    public final ModelPart leg7;
    public final ModelPart leg13;
    public final ModelPart leg8;
    public final ModelPart leg9;

    public ModelZombieBroodling(ModelPart root) {
        super(root);
        this.head = root.getChild("head");
        this.neck = root.getChild("neck");
        this.body = root.getChild("body");
        this.leg1 = root.getChild("leg1");
        this.leg16 = this.leg1.getChild("leg16");
        this.leg2 = root.getChild("leg2");
        this.leg12 = this.leg2.getChild("leg12");
        this.leg3 = root.getChild("leg3");
        this.leg15 = this.leg3.getChild("leg15");
        this.leg4 = root.getChild("leg4");
        this.leg11 = this.leg4.getChild("leg11");
        this.leg5 = root.getChild("leg5");
        this.leg14 = this.leg5.getChild("leg14");
        this.leg6 = root.getChild("leg6");
        this.leg10 = this.leg6.getChild("leg10");
        this.leg7 = root.getChild("leg7");
        this.leg13 = this.leg7.getChild("leg13");
        this.leg8 = root.getChild("leg8");
        this.leg9 = this.leg8.getChild("leg9");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 4).addBox(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)-3.0f));
        PartDefinition neck = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-5.0f, -4.0f, -6.0f, 10.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)9.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(22, 0).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)3.0f, (float)0.4597f, (float)0.4176f, (float)0.8845f));
        PartDefinition leg16 = leg1.addOrReplaceChild("leg16", CubeListBuilder.create().texOffs(19, 0).addBox(-14.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg2 = partdefinition.addOrReplaceChild("leg2", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)3.0f, (float)0.4597f, (float)-0.4176f, (float)-0.8845f));
        PartDefinition leg12 = leg2.addOrReplaceChild("leg12", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg3 = partdefinition.addOrReplaceChild("leg3", CubeListBuilder.create().texOffs(22, 0).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)1.0f, (float)0.0618f, (float)0.0617f, (float)0.7873f));
        PartDefinition leg15 = leg3.addOrReplaceChild("leg15", CubeListBuilder.create().texOffs(19, 0).addBox(-14.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg4 = partdefinition.addOrReplaceChild("leg4", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)1.0f, (float)0.0618f, (float)-0.0617f, (float)-0.7873f));
        PartDefinition leg11 = leg4.addOrReplaceChild("leg11", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg5 = partdefinition.addOrReplaceChild("leg5", CubeListBuilder.create().texOffs(22, 0).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)-2.0f, (float)-0.0618f, (float)-0.0617f, (float)0.7873f));
        PartDefinition leg14 = leg5.addOrReplaceChild("leg14", CubeListBuilder.create().texOffs(19, 0).addBox(-14.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg6 = partdefinition.addOrReplaceChild("leg6", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)-2.0f, (float)-0.0618f, (float)0.0617f, (float)-0.7873f));
        PartDefinition leg10 = leg6.addOrReplaceChild("leg10", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        PartDefinition leg7 = partdefinition.addOrReplaceChild("leg7", CubeListBuilder.create().texOffs(22, 0).addBox(-11.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)18.0f, (float)-4.0f, (float)-0.4597f, (float)-0.4176f, (float)0.8845f));
        PartDefinition leg13 = leg7.addOrReplaceChild("leg13", CubeListBuilder.create().texOffs(19, 0).addBox(-14.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.8326f));
        PartDefinition leg8 = partdefinition.addOrReplaceChild("leg8", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 12.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)18.0f, (float)-4.0f, (float)-0.4597f, (float)0.4176f, (float)-0.8845f));
        PartDefinition leg9 = leg8.addOrReplaceChild("leg9", CubeListBuilder.create().texOffs(18, 0).addBox(-1.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.8326f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg1.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg4.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg5.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.leg3.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg8.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg6.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.leg7.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

