/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.broodmotherswrath.network;

import java.util.function.Supplier;
import net.mcreator.broodmotherswrath.BroodMothersWrathMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class BroodMothersWrathModVariables {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"brood_mothers_wrath");
    public static final Supplier<AttachmentType<PlayerVariables>> PLAYER_VARIABLES = ATTACHMENT_TYPES.register("player_variables", () -> AttachmentType.serializable(() -> new PlayerVariables()).build());

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BroodMothersWrathMod.addNetworkMessage(SavedDataSyncMessage.TYPE, SavedDataSyncMessage.STREAM_CODEC, SavedDataSyncMessage::handleData);
        BroodMothersWrathMod.addNetworkMessage(PlayerVariablesSyncMessage.TYPE, PlayerVariablesSyncMessage.STREAM_CODEC, PlayerVariablesSyncMessage::handleData);
    }

    public record SavedDataSyncMessage(int dataType, SavedData data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SavedDataSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brood_mothers_wrath", (String)"saved_data_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, SavedDataSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.writeNbt((Tag)message.data.save(new CompoundTag(), (HolderLookup.Provider)buffer.registryAccess()));
            }
        }, buffer -> {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.readNbt();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt, (HolderLookup.Provider)buffer.registryAccess());
                }
            }
            return new SavedDataSyncMessage(dataType, data);
        });

        public CustomPacketPayload.Type<SavedDataSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(SavedDataSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    } else {
                        WorldVariables.clientSide.read(message.data.save(new CompoundTag(), (HolderLookup.Provider)context.player().registryAccess()), (HolderLookup.Provider)context.player().registryAccess());
                    }
                }).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<PlayerVariablesSyncMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"brood_mothers_wrath", (String)"player_variables_sync"));
        public static final StreamCodec<RegistryFriendlyByteBuf, PlayerVariablesSyncMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> buffer.writeNbt((Tag)message.data().serializeNBT((HolderLookup.Provider)buffer.registryAccess())), buffer -> {
            PlayerVariablesSyncMessage message = new PlayerVariablesSyncMessage(new PlayerVariables());
            message.data.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), buffer.readNbt());
            return message;
        });

        public CustomPacketPayload.Type<PlayerVariablesSyncMessage> type() {
            return TYPE;
        }

        public static void handleData(PlayerVariablesSyncMessage message, IPayloadContext context) {
            if (context.flow() == PacketFlow.CLIENTBOUND && message.data != null) {
                context.enqueueWork(() -> ((PlayerVariables)context.player().getData(PLAYER_VARIABLES)).deserializeNBT((HolderLookup.Provider)context.player().registryAccess(), message.data.serializeNBT((HolderLookup.Provider)context.player().registryAccess()))).exceptionally(e -> {
                    context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                    return null;
                });
            }
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        public double WebRegenBonus = 0.0;
        public double WebFluidMax = 20.0;
        public double WebFluid = 0.0;
        public boolean UndeadAB = false;
        public double RegenTimer = 40.0;
        public boolean PlayerIsBroodmother = false;
        public double PlayerAbilityPoints = 0.0;
        public double Player_Experience = 0.0;
        public double Player_Brood_Level = 0.0;
        public boolean FarmerAB = false;
        public double CurrentSaturation = 0.0;
        public double CurrentRegenTimer = 0.0;
        public double CurrentHunger = 0.0;
        public double APBonus = 0.0;
        public boolean Altar_Is_Active = false;
        public double WebStrengthBonus = 0.0;
        public boolean hasChosenPath = false;

        public CompoundTag serializeNBT(HolderLookup.Provider lookupProvider) {
            CompoundTag nbt = new CompoundTag();
            nbt.putDouble("WebRegenBonus", this.WebRegenBonus);
            nbt.putDouble("WebFluidMax", this.WebFluidMax);
            nbt.putDouble("WebFluid", this.WebFluid);
            nbt.putBoolean("UndeadAB", this.UndeadAB);
            nbt.putDouble("RegenTimer", this.RegenTimer);
            nbt.putBoolean("PlayerIsBroodmother", this.PlayerIsBroodmother);
            nbt.putDouble("PlayerAbilityPoints", this.PlayerAbilityPoints);
            nbt.putDouble("Player_Experience", this.Player_Experience);
            nbt.putDouble("Player_Brood_Level", this.Player_Brood_Level);
            nbt.putBoolean("FarmerAB", this.FarmerAB);
            nbt.putDouble("CurrentSaturation", this.CurrentSaturation);
            nbt.putDouble("CurrentRegenTimer", this.CurrentRegenTimer);
            nbt.putDouble("CurrentHunger", this.CurrentHunger);
            nbt.putDouble("APBonus", this.APBonus);
            nbt.putBoolean("Altar_Is_Active", this.Altar_Is_Active);
            nbt.putDouble("WebStrengthBonus", this.WebStrengthBonus);
            nbt.putBoolean("hasChosenPath", this.hasChosenPath);
            return nbt;
        }

        public void deserializeNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
            this.WebRegenBonus = nbt.getDouble("WebRegenBonus");
            this.WebFluidMax = nbt.getDouble("WebFluidMax");
            this.WebFluid = nbt.getDouble("WebFluid");
            this.UndeadAB = nbt.getBoolean("UndeadAB");
            this.RegenTimer = nbt.getDouble("RegenTimer");
            this.PlayerIsBroodmother = nbt.getBoolean("PlayerIsBroodmother");
            this.PlayerAbilityPoints = nbt.getDouble("PlayerAbilityPoints");
            this.Player_Experience = nbt.getDouble("Player_Experience");
            this.Player_Brood_Level = nbt.getDouble("Player_Brood_Level");
            this.FarmerAB = nbt.getBoolean("FarmerAB");
            this.CurrentSaturation = nbt.getDouble("CurrentSaturation");
            this.CurrentRegenTimer = nbt.getDouble("CurrentRegenTimer");
            this.CurrentHunger = nbt.getDouble("CurrentHunger");
            this.APBonus = nbt.getDouble("APBonus");
            this.Altar_Is_Active = nbt.getBoolean("Altar_Is_Active");
            this.WebStrengthBonus = nbt.getDouble("WebStrengthBonus");
            this.hasChosenPath = nbt.getBoolean("hasChosenPath");
        }

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new PlayerVariablesSyncMessage(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "brood_mothers_wrath_mapvars";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            MapVariables data = new MapVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof Level && !world.isClientSide()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new SavedDataSyncMessage(0, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.getLevel().getServer().getLevel(Level.OVERWORLD).getDataStorage().computeIfAbsent(new SavedData.Factory(MapVariables::new, MapVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "brood_mothers_wrath_worldvars";
        public double ZombieReputation = 100.0;
        public double SpiderReputation = 100.0;
        public double SkeletonReputation = 100.0;
        public double HumanReputation = 0.0;
        public double CreeperReputation = 100.0;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag, HolderLookup.Provider lookupProvider) {
            WorldVariables data = new WorldVariables();
            data.read(tag, lookupProvider);
            return data;
        }

        public void read(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            this.ZombieReputation = nbt.getDouble("ZombieReputation");
            this.SpiderReputation = nbt.getDouble("SpiderReputation");
            this.SkeletonReputation = nbt.getDouble("SkeletonReputation");
            this.HumanReputation = nbt.getDouble("HumanReputation");
            this.CreeperReputation = nbt.getDouble("CreeperReputation");
        }

        public CompoundTag save(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
            nbt.putDouble("ZombieReputation", this.ZombieReputation);
            nbt.putDouble("SpiderReputation", this.SpiderReputation);
            nbt.putDouble("SkeletonReputation", this.SkeletonReputation);
            nbt.putDouble("HumanReputation", this.HumanReputation);
            nbt.putDouble("CreeperReputation", this.CreeperReputation);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.setDirty();
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new SavedDataSyncMessage(1, this), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.getDataStorage().computeIfAbsent(new SavedData.Factory(WorldVariables::new, WorldVariables::load), DATA_NAME);
            }
            return clientSide;
        }
    }

    @EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ((PlayerVariables)player2.getData(PLAYER_VARIABLES)).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            PlayerVariables original = (PlayerVariables)event.getOriginal().getData(PLAYER_VARIABLES);
            PlayerVariables clone = new PlayerVariables();
            clone.WebRegenBonus = original.WebRegenBonus;
            clone.WebFluidMax = original.WebFluidMax;
            clone.UndeadAB = original.UndeadAB;
            clone.PlayerIsBroodmother = original.PlayerIsBroodmother;
            clone.PlayerAbilityPoints = original.PlayerAbilityPoints;
            clone.Player_Experience = original.Player_Experience;
            clone.Player_Brood_Level = original.Player_Brood_Level;
            clone.FarmerAB = original.FarmerAB;
            clone.APBonus = original.APBonus;
            clone.Altar_Is_Active = original.Altar_Is_Active;
            clone.WebStrengthBonus = original.WebStrengthBonus;
            clone.hasChosenPath = original.hasChosenPath;
            if (!event.isWasDeath()) {
                clone.WebFluid = original.WebFluid;
                clone.RegenTimer = original.RegenTimer;
                clone.CurrentSaturation = original.CurrentSaturation;
                clone.CurrentRegenTimer = original.CurrentRegenTimer;
                clone.CurrentHunger = original.CurrentHunger;
            }
            event.getEntity().setData(PLAYER_VARIABLES, (Object)clone);
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().level());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (mapdata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(0, mapdata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().level());
                if (worlddata != null) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SavedDataSyncMessage(1, worlddata), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }
}

