/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.betterthancopper.procedures;

import io.netty.buffer.Unpooled;
import net.mcreator.betterthancopper.world.inventory.BlockDetectorGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlockDetectorOnBlockRightClickedProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (!BlockDetectorOnBlockRightClickedProcedure.getBlockNBTLogic(world, BlockPos.containing((double)x, (double)y, (double)z), "locked") && entity instanceof ServerPlayer) {
            ServerPlayer _ent = (ServerPlayer)entity;
            final BlockPos _bpos = BlockPos.containing((double)x, (double)y, (double)z);
            _ent.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"BlockDetectorGUI");
                }

                public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                    return false;
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new BlockDetectorGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(_bpos));
                }
            }, _bpos);
        }
    }

    private static boolean getBlockNBTLogic(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getBoolean(tag);
        }
        return false;
    }
}

