/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.notsodeepdark.block;

import java.util.Optional;
import net.mcreator.notsodeepdark.init.NotSoDeepDarkModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class InfestedFungusBlock
extends SaplingBlock {
    public static final TreeGrower TREE_GROWER = new TreeGrower("infested_fungus", Optional.empty(), Optional.of(InfestedFungusBlock.getFeatureKey("not_so_deep_dark:infested_hyphae")), Optional.empty());

    public InfestedFungusBlock(BlockBehaviour.Properties properties) {
        super(TREE_GROWER, properties.mapColor(MapColor.PLANT).randomTicks().sound(SoundType.FUNGUS).instabreak().noCollission().pushReaction(PushReaction.DESTROY));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public boolean mayPlaceOn(BlockState groundState, BlockGetter worldIn, BlockPos pos) {
        return groundState.is((Block)NotSoDeepDarkModBlocks.INFESTED_NYLIUM.get());
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState groundState = worldIn.getBlockState(blockpos);
        return this.mayPlaceOn(groundState, (BlockGetter)worldIn, blockpos);
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> getFeatureKey(String feature) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.parse((String)feature));
    }
}

