/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import si.pylo.mcreator.Block;
import si.pylo.mcreator.MCDialog;
import si.pylo.mcreator.MainUI;

public class BlockSelector
extends MCDialog {
    private static final long serialVersionUID = 1L;
    JButton naprej = new JButton("Vredu");
    FilterModel model = new FilterModel();
    JList list = new JList(this.model);
    JTextField jtf = new JTextField(12);
    JTextField filterField = new JTextField(20);

    public BlockSelector(Block[] block) {
        super((Window)null);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("./res/gui/icon.png"));
        this.list.setCellRenderer(new Render());
        int i = 0;
        while (i < block.length) {
            this.model.addElement(block[i]);
            ++i;
        }
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                BlockSelector.this.model.refilter();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                BlockSelector.this.model.refilter();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                BlockSelector.this.model.refilter();
            }
        });
        this.jtf.setEditable(false);
        Properties lang = new Properties();
        try {
            lang.load(new FileInputStream("./res/data/lang/GUI_" + MainUI.lang + ".lang"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    BlockSelector.this.naprej.doClick();
                }
            }
        });
        this.naprej.setText(lang.getProperty("ok"));
        JPanel buttons = new JPanel();
        JButton naprej2 = new JButton(lang.getProperty("cancel"));
        buttons.add(this.naprej);
        buttons.add(naprej2);
        this.list.setLayoutOrientation(1);
        this.list.setVisibleRowCount(7);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                Block bl = (Block)BlockSelector.this.list.getSelectedValue();
                BlockSelector.this.jtf.setText(bl.name);
            }
        });
        naprej2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlockSelector.this.setVisible(false);
            }
        });
        JTabbedPane pan = new JTabbedPane();
        pan.addTab("All blocks and items", new JScrollPane(this.list));
        JPanel ps = new JPanel();
        ps.add(new JLabel("Block ID: "));
        ps.add(this.jtf);
        ps.add(new JSeparator());
        ps.add(new JLabel("Filter: "));
        ps.add(this.filterField);
        JPanel ps2 = new JPanel();
        JButton blocks = new JButton("Blocks");
        blocks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlockSelector.this.filterField.setText("Blocks.");
            }
        });
        JButton items = new JButton("Items");
        items.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlockSelector.this.filterField.setText("Items.");
            }
        });
        JButton mods = new JButton("Mod");
        mods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlockSelector.this.filterField.setText("mcreator_");
            }
        });
        JButton dict = new JButton("Ore dictionary");
        dict.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BlockSelector.this.filterField.setText("OreDictionary");
            }
        });
        ps2.add(new JLabel("Filter presets: "));
        ps2.add(blocks);
        ps2.add(items);
        ps2.add(mods);
        ps2.add(dict);
        JPanel toppan = new JPanel(new BorderLayout());
        toppan.add("North", ps);
        toppan.add("South", ps2);
        this.add("North", toppan);
        this.add("South", buttons);
        this.add("Center", pan);
        this.setSize(570, 390);
        this.setResizable(false);
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 2, (dim.height - abounds.height) / 2);
        this.setLocationRelativeTo(MainUI.globalMainUI);
    }

    class FilterModel
    extends DefaultListModel {
        private static final long serialVersionUID = 1L;
        ArrayList items = new ArrayList();
        ArrayList filterItems = new ArrayList();

        @Override
        public Object getElementAt(int index) {
            if (index < this.filterItems.size()) {
                return this.filterItems.get(index);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.filterItems.size();
        }

        public void addElement(Object o) {
            this.items.add(o);
            this.refilter();
        }

        @Override
        public void removeAllElements() {
            super.removeAllElements();
            this.items.clear();
            this.filterItems.clear();
        }

        @Override
        public boolean removeElement(Object a) {
            this.items.remove(a);
            this.filterItems.remove(a);
            return super.removeElement(a);
        }

        private void refilter() {
            this.filterItems.clear();
            String term = BlockSelector.this.filterField.getText();
            int i = 0;
            while (i < this.items.size()) {
                if (((Block)this.items.get((int)i)).name.toLowerCase().indexOf(term.toLowerCase(), 0) != -1) {
                    this.filterItems.add(this.items.get(i));
                }
                ++i;
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    class Render
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        Render() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Block ma = (Block)value;
            if (isSelected) {
                this.setBackground(Color.blue);
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setIcon(ma.icon);
            return this;
        }
    }
}

