/*
 * Decompiled with CFR 0.152.
 */
package si.pylo.mcreator;

import javax.swing.DefaultComboBoxModel;

public class CaseRegex {
    public static String convertCaseSyntaxToCaseCode(String origin) {
        if (origin.equals("isDay[]")) {
            return "world.isDaytime()";
        }
        if (origin.equals("isNight[]")) {
            return "!world.isDaytime()";
        }
        if (origin.startsWith("isAirBlock[")) {
            return "world.isAirBlock(new BlockPos(" + origin.replaceAll("isAirBlock\\[", "").replaceAll("\\]", "") + "))";
        }
        if (origin.startsWith("canBlockSeeTheSky[")) {
            return "world.canSeeSky(new BlockPos(" + origin.replaceAll("canBlockSeeTheSky\\[", "").replaceAll("\\]", "") + "))";
        }
        if (origin.equals("isRaining[]")) {
            return "world.isRaining()";
        }
        if (origin.equals("isThundering[]")) {
            return "world.isThundering()";
        }
        if (origin.equals("isNotRaining[]")) {
            return "!world.isRaining()";
        }
        if (origin.startsWith("heightValue[")) {
            return "world.getHorizon(new BlockPos(" + origin.replaceAll("heightValue\\[", "").replaceAll("\\]", ")") + "))";
        }
        if (origin.equals("isPlayerUsingAnyItem[]")) {
            return "entity.isUsingItem()";
        }
        if (origin.startsWith("playerArmorValue[")) {
            return "entity.getTotalArmorValue(" + origin.replaceAll("playerArmorValue\\[", "").replaceAll("\\]", ")");
        }
        if (origin.startsWith("isBlockBedrockAt[")) {
            return "world.getBlockState(new BlockPos(" + origin.replaceAll("isBlockBedrockAt\\[", "").replaceAll("\\]", "") + ")).getBlock() == Blocks.bedrock";
        }
        if (origin.startsWith("isNotBlockBedrockAt[")) {
            return "world.getBlockState(new BlockPos(" + origin.replaceAll("isBlockBedrockAt\\[", "").replaceAll("\\]", "") + ")).getBlock() != Blocks.bedrock";
        }
        if (origin.startsWith("hasPlayerInInventory[")) {
            return "entity.inventory.hasItem(new ItemStack(" + origin.replaceAll("hasPlayerInInventory\\[", "").replaceAll("\\]", "") + ").getItem())";
        }
        if (origin.startsWith("randomPossibility[")) {
            String pos = origin.replaceAll("randomPossibility\\[", "").replaceAll("\\%\\]", "");
            return "(Math.random()*100) <= " + pos;
        }
        if (origin.startsWith("blockAt[")) {
            return "world.getBlockState(new BlockPos(" + origin.replaceAll("blockAt\\[", "").replaceAll("\\]", "))");
        }
        if (origin.startsWith("itemInPlayersHand[")) {
            return origin.replaceAll("itemInPlayersHand\\[\\]", "entity.inventory.getCurrentItem()!=null&&entity.inventory.getCurrentItem().getItem()");
        }
        if (origin.startsWith("dimensionId[")) {
            return origin.replaceAll("dimensionId\\[\\]", "world.provider.getDimensionId()");
        }
        if (origin.startsWith("isVariableTrue[")) {
            return "mcreator_VarList%MAINMODNAME%." + origin.replaceAll("isVariableTrue\\[", "").replaceAll("\\]", "");
        }
        if (origin.startsWith("isVariableFalse[")) {
            return "!mcreator_VarList%MAINMODNAME%." + origin.replaceAll("isVariableTrue\\[", "").replaceAll("\\]", "");
        }
        if (origin.contains("=")) {
            return origin.replaceAll("=", "==").replaceAll("VAR:", "mcreator_VarList%MAINMODNAME%.");
        }
        if (origin.contains(">")) {
            return origin.replaceAll("VAR:", "mcreator_VarList%MAINMODNAME%.");
        }
        if (origin.contains("<")) {
            return origin.replaceAll("VAR:", "mcreator_VarList%MAINMODNAME%.");
        }
        if (origin.equals("") || origin.contains("(In all cases)")) {
            return "true";
        }
        return origin;
    }

    public static void loadCaseOptionsInTheCaseRegistry(DefaultComboBoxModel<String> model) {
        model.addElement("(In all cases)");
        model.addElement("hasPlayerInInventory[item/block]");
        model.addElement("itemInPlayersHand[] == item");
        model.addElement("NUMBER = NUMBER");
        model.addElement("NUMBER > NUMBER");
        model.addElement("NUMBER < NUMBER");
        model.addElement("isVariableTrue[variable]");
        model.addElement("isVariableFalse[variable]");
        model.addElement("randomPossibility[50%]");
        model.addElement("isNotBlockBedrockAt[i, j, k]");
        model.addElement("isBlockBedrockAt[i, j, k]");
        model.addElement("blockAt[i, j, k] == item/block");
        model.addElement("blockAt[i, j, k] != item/block");
        model.addElement("isDay[]");
        model.addElement("isNight[]");
        model.addElement("isRaining[]");
        model.addElement("dimensionId[] == 0");
        model.addElement("isNotRaining[]");
        model.addElement("isThundering[]");
        model.addElement("isAirBlock[i, j, k]");
        model.addElement("canBlockSeeTheSky[i, j, k]");
        model.addElement("heightValue[i, k] > 100");
        model.addElement("isPlayerUsingAnyItem[]");
        model.addElement("playerArmorValue[] > 1");
    }
}

